/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.target;

import oracle.bpm.designer.capability.ControllerCapabilityImpl;
import oracle.bpm.designer.capability.target.TargetFeedback;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

public abstract class TargetCapability<T extends FlowElement>
extends ControllerCapabilityImpl<T> {
    private TargetFeedback<T> feedback;
    private boolean showing = false;

    protected TargetCapability(@NotNull FlowElementController<T> controller) {
        super(controller);
    }

    public void showTargetFeedback(@NotNull FlowElementController<?> source) {
        if (!this.showing) {
            this.feedback = this.createFeedback(source);
            this.showing = true;
            this.getDrawableContainer().addChild(this.feedback);
            this.showTargetFeedback(this.feedback, source);
            this.repaintFeedbackRegion();
        } else {
            boolean accepted = this.feedback.isAccepted();
            this.showTargetFeedback(this.feedback, source);
            if (accepted != this.feedback.isAccepted()) {
                this.repaintFeedbackRegion();
            }
        }
    }

    public void eraseTargetFeedback(@NotNull FlowElementController<?> source) {
        this.getDrawableContainer().removeChild(this.feedback);
        this.repaintFeedbackRegion();
        this.showing = false;
        this.feedback = null;
    }

    abstract void showTargetFeedback(@NotNull TargetFeedback<T> var1, @NotNull FlowElementController<?> var2);

    @NotNull
    abstract TargetFeedback<T> createFeedback(@NotNull FlowElementController<?> var1);

    Rectangle buildFeedbackDirtyRegionRectangle() {
        return this.feedback.getBounds(this.getDrawContext());
    }

    private void repaintFeedbackRegion() {
        Rectangle postDragRectangle = this.getDrawContext().scaleRectangle(this.buildFeedbackDirtyRegionRectangle());
        this.getCanvas().paintImmediately(postDragRectangle);
    }
}

