/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.selection;

import oracle.bpm.command.Command;
import oracle.bpm.designer.action.ProcessCanvasActions;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.selection.ProcessSelectionCapability;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.selection.DefaultSelection;
import org.jetbrains.annotations.NotNull;

public class ProcessPopUpCapability
extends ProcessSelectionCapability {
    public ProcessPopUpCapability(@NotNull ProcessController controller) {
        this(CapabilityType.POP_UP, controller);
    }

    public ProcessPopUpCapability(@NotNull CapabilityType type, @NotNull ProcessController controller) {
        super(type, controller);
        this.setSpecifyParent(false);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        super.process(event);
        PopupMenu menu = this.createPopUpForProcess(event.getLocation());
        if (menu != null) {
            MouseEvent mouse = event.getEvent();
            menu.show((UiComponent)this.getDomain().getCanvas(), mouse.getX(), mouse.getY());
        }
        return null;
    }

    private PopupMenu createPopUpForProcess(@NotNull Point point) {
        ActionGroup result = new ProcessCanvasActions(this.getDomain(), point).buildActions();
        if (result != null) {
            result.setSelection(DefaultSelection.createSingle(this.getController().getModelObject()));
        }
        return PopupMenu.create((UiContainer)this.getDomain().getCanvas(), (ActionGroup)result);
    }
}

