/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.selection;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.Capability;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.CapableController;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.selection.DomainSelectionProvider;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class ElementSelectionCapability
extends Capability {
    public ElementSelectionCapability(@NotNull CapableController controller) {
        this(CapabilityType.SELECTION, controller);
    }

    protected ElementSelectionCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        DomainSelectionProvider provider = this.getDomain().getSelectionProvider();
        MouseEvent mouse = event.getEvent();
        boolean shift = mouse != null && mouse.isShiftDown();
        boolean control = mouse != null && mouse.isControlDown();
        boolean selected = this.getSelectableController().getSelection().isSelected();
        if (shift || control && !selected) {
            Controller capableController = this.getSelectableController();
            provider.append(capableController);
        } else if (control && selected) {
            provider.remove(this.getSelectableController());
        } else {
            provider.setSelection(this.getSelectableController());
        }
        return null;
    }

    protected Controller getSelectableController() {
        return this.getController();
    }
}

