/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.selection;

import oracle.bpm.command.Command;
import oracle.bpm.designer.action.FlowNodeActions;
import oracle.bpm.designer.action.SelectionActions;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.CapableController;
import oracle.bpm.designer.capability.selection.ElementSelectionCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.selection.SelectionUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.CompositeMenu;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class ElementPopUpCapability
extends ElementSelectionCapability {
    public ElementPopUpCapability(@NotNull CapableController controller) {
        this(CapabilityType.POP_UP, controller);
    }

    protected ElementPopUpCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
        this.setSpecifyParent(false);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        super.process(event);
        Selection selection = this.getSelection();
        boolean single = selection.isSingle();
        PopupMenu menu = null;
        if (single) {
            Controller raw = this.getSelectableController();
            if (raw instanceof FlowElementController) {
                FlowElementController controller = (FlowElementController)raw;
                Object element = controller.getModelObject();
                ActionGroup group = ActionGroup.create(element, (Class)element.getRawClass());
                if (controller instanceof FlowNodeController) {
                    ActionGroup extras = FlowNodeActions.build((FlowNodeController)controller);
                    group.addAll(extras.getActions());
                    group.sort();
                }
                group.setSelection(selection);
                menu = new PopupMenu((UiContainer)this.getDomain().getCanvas());
                group.setInline(true);
                group.addToMenu((CompositeMenu)menu);
            }
        } else {
            menu = this.createRightClickMultipleSelectionPopup();
        }
        if (menu != null) {
            MouseEvent mouse = event.getEvent();
            menu.show((UiComponent)this.getDomain().getCanvas(), mouse.getX(), mouse.getY());
        }
        return null;
    }

    public PopupMenu createRightClickMultipleSelectionPopup() {
        ModelObjectSelection objectSelection = SelectionUtils.asModelObjectSelection(this.getSelection());
        SelectionActions selectionActions = new SelectionActions(objectSelection);
        return PopupMenu.create((UiContainer)this.getDomain().getCanvas(), (ActionGroup)selectionActions.getActions());
    }

    private Selection getSelection() {
        return this.getDomain().getSelectionProvider().getSelection();
    }
}

