/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.edit;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.edit.ElementInplaceEditCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.subcontroller.ExpandCollapseSubcontroller;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.draw.renderer.SubprocessRenderer;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class ExpandCollapseCapability
extends ElementInplaceEditCapability {
    public ExpandCollapseCapability(@NotNull ExpandCollapseSubcontroller controller) {
        super(controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command process(@NotNull CapabilityEvent event) {
        ExpandCollapseSubcontroller subcontroller = this.getController();
        Controller controller = subcontroller.getContainer();
        Controller container = controller.getContainer();
        Subprocess subprocess = (Subprocess)subcontroller.getModelObject();
        controller.remove();
        IsCollapsedFeature feature = (IsCollapsedFeature)subprocess.getFeature(IsCollapsedFeature.class);
        Transactable transactable = (Transactable)subprocess.getProcess();
        try {
            transactable.beginTransaction();
            feature.toggleValue();
            container.refresh();
            DrawableEvent.updateBoundaries((DrawContext)this.getDomain().getDrawContext(), container.getDrawableObject(), (Activity)subprocess);
        }
        finally {
            transactable.endTransaction();
        }
        this.getDomain().getCanvas().repaint();
        return null;
    }

    @Override
    @NotNull
    protected ExpandCollapseSubcontroller getController() {
        return (ExpandCollapseSubcontroller)super.getController();
    }

    private void setupInitialBounds(@NotNull Drawable drawable, @NotNull SubprocessFeedback feedback) {
        DrawContext context = this.getDomain().getDrawContext();
        Rectangle bounds = drawable.getBounds(context);
        feedback.setLocation(bounds.getCenter());
        feedback.setWidth(context, bounds.getWidth());
        feedback.setHeight(context, bounds.getHeight());
    }

    private static final class SubprocessFeedback
    extends DrawableImpl<Subprocess> {
        protected SubprocessFeedback(Drawable container, @NotNull Subprocess subprocess) {
            super(container, (Object)subprocess, DesignerLayer.CAPABILITY);
        }

        protected Renderer createRenderer() {
            return SubprocessRenderer.create((Drawable)this);
        }
    }
}

