/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.drag.ElementResizeCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.Subcontroller;
import oracle.bpm.designer.subcontroller.ResizeSubcontroller;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.ResizePositionalCommand;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class SubprocessResizeCapability
extends ElementResizeCapability {
    public SubprocessResizeCapability(@NotNull ResizeSubcontroller controller) {
        super(controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        Rectangle minimum = Rectangle.ZERO;
        for (Controller controller : this.getParentController().getControllers()) {
            if (controller instanceof Subcontroller) continue;
            Rectangle bounds = controller.getDrawableObject().getBounds(this.getDrawContext());
            minimum = minimum == Rectangle.ZERO ? bounds : minimum.union(bounds);
        }
        Point origin = this.getParentController().getDrawableObject().getBounds(this.getDrawContext()).getOrigin();
        this.minimum = Rectangle.deriveFromPoints(origin, minimum.getTop().translate(5, 5));
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        ResizePositionalCommand result = null;
        Rectangle resize = this.getResizeBounds(event);
        if (this.getController().getModelObject() instanceof Subprocess) {
            Subprocess subprocess = (Subprocess)this.getController().getModelObject();
            result = new ResizePositionalCommand((Positional)subprocess, resize.getCenter(), resize.getWidth(), resize.getHeight());
            Controller container = this.getParentController().getContainer();
            DrawableEvent.updateBoundaries((DrawContext)this.getDomain().getDrawContext(), container.getDrawableObject(), (Activity)subprocess);
        }
        return result;
    }
}

