/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.drag.DraggableCapability;
import oracle.bpm.designer.controller.ControllerContainer;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.NullModelObject;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class ProcessMarqueeCapability
extends DraggableCapability {
    private DrawableRectangle rectangle;

    public ProcessMarqueeCapability(@NotNull ProcessController controller) {
        this(CapabilityType.MARQUEE, controller);
    }

    protected ProcessMarqueeCapability(@NotNull CapabilityType type, @NotNull ProcessController controller) {
        super(type, controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        this.getDrawableRectangle().add();
        this.getDrawableRectangle().setLocation(event.getLocation());
    }

    @Override
    public void drag(@NotNull CapabilityEvent event) {
        this.updateSelection(event.getLocation());
    }

    @Override
    public void endDrag(@NotNull CapabilityEvent event) {
        this.getDrawableRectangle().remove();
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        return null;
    }

    @Override
    @NotNull
    protected ProcessController getController() {
        return (ProcessController)super.getController();
    }

    private void updateSelection(@NotNull Point location) {
        this.getDrawableRectangle().updateSizeTo(location);
        List<FlowElementController> copy = this.getControllersInsideRectangle();
        Selection selection = copy.isEmpty() ? DefaultSelection.EMPTY : DefaultSelection.createMultiple(copy);
        this.getDomain().getSelectionProvider().setSelection(selection);
    }

    private List<FlowElementController> getControllersInsideRectangle() {
        DrawContext context = this.getDrawContext();
        return ControllerUtils.getControllersAt((ControllerContainer)this.getController().getContainer(), this.getDrawableRectangle().getBounds(context), context);
    }

    private DrawableRectangle getDrawableRectangle() {
        if (this.rectangle == null) {
            this.rectangle = new DrawableRectangle((Drawable)this.getController().getDrawableObject());
        }
        return this.rectangle;
    }

    private DrawContext getDrawContext() {
        return this.getController().getDomain().getDrawContext();
    }

    private static class DrawableRectangle
    extends DrawableFeedback<NullModelObject> {
        private Point origin;
        private Rectangle rectangle;

        private DrawableRectangle(@NotNull Drawable container) {
            super(container, NullModelObject.getInstance(), DesignerLayer.SELECTION);
        }

        public void setLocation(@NotNull Point location) {
            this.origin = location;
            this.rectangle = Rectangle.valueOf(this.origin, 0, 0);
        }

        @NotNull
        public Point getLocation() {
            return this.rectangle.getOrigin();
        }

        public void updateSizeTo(@NotNull Point location) {
            this.rectangle = Rectangle.deriveFromPoints(this.origin, location);
        }

        @NotNull
        public Rectangle getBounds(@NotNull DrawContext context) {
            return Rectangle.valueOf(this.getLocation(), this.getWidth(context), this.getHeight(context));
        }

        public int getWidth(@NotNull DrawContext context) {
            return this.rectangle.getWidth();
        }

        public int getHeight(@NotNull DrawContext context) {
            return this.rectangle.getHeight();
        }

        public void draw(@NotNull DrawContext context) {
            Rectangle bounds = this.getBounds(context).scaled(context.getScale());
            Graphics graphics = context.getGraphics();
            Stroke stroke = graphics.getStroke();
            Color color = graphics.getForeground();
            graphics.setForeground(Color.TRANSLUCENT_35);
            graphics.fillRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            graphics.setStroke(Stroke.ONE_SOLID);
            graphics.setForeground(Color.FUEGO_BLUE);
            graphics.drawRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            graphics.setForeground(color);
            graphics.setStroke(stroke);
        }
    }
}

