/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.drag.ElementResizeCapability;
import oracle.bpm.designer.subcontroller.ResizeSubcontroller;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.model.processes.TextAnnotation;
import org.jetbrains.annotations.NotNull;

public class NoteResizeCapability
extends ElementResizeCapability {
    public NoteResizeCapability(@NotNull ResizeSubcontroller controller) {
        super(controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        Point origin = this.getParentController().getDrawableObject().getBounds(this.getDrawContext()).getOrigin();
        this.minimum = Rectangle.valueOf(origin, TextAnnotationImpl.MINIMUM_SIZE);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        Rectangle result = this.getResizeBounds(event);
        if (this.getController().getModelObject() instanceof TextAnnotation) {
            TextAnnotation note = (TextAnnotation)this.getController().getModelObject();
            note.setLocation(result.getCenter());
            note.setWidth(result.getWidth());
            note.setHeight(result.getHeight());
        }
        this.getDomain().getCanvas().repaint();
        return null;
    }
}

