/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.drag.ImageDraggableCapability;
import oracle.bpm.designer.controller.LaneColumnController;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.command.design.ResizeLaneCommand;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import org.jetbrains.annotations.NotNull;

public class LaneResizeCapability
extends ImageDraggableCapability {
    private DragMinimumSizeController sizeController = new DragMinimumSizeController();
    private static final Color RED_TRANSLUCENT = Color.valueOf((int)200, (int)20, (int)20, (int)150);
    private static final Color WHITE_TRANSLUCENT = Color.valueOf((Color)Color.WHITE, (int)180);

    public LaneResizeCapability(@NotNull LaneColumnController controller) {
        this(CapabilityType.RESIZE, controller);
    }

    protected LaneResizeCapability(@NotNull CapabilityType type, @NotNull LaneColumnController controller) {
        super(type, controller);
    }

    @Override
    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.eraseSourceVisuals(event);
    }

    @Override
    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return Point.ORIGIN;
    }

    @Override
    protected void startDrag(@NotNull DrawableFeedback feedback, @NotNull CapabilityEvent event) {
        this.sizeController.setMinimumSize((Lane)this.getController().getModelObject());
        super.startDrag(feedback, event);
    }

    @Override
    protected void drag(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        DrawContext context = this.getDrawContext();
        int offsetPlusSize = context.isHorizontalDrawing() ? destination.getY() : destination.getX();
        boolean valid = this.sizeController.checkValidNewOffsetPlusSize(offsetPlusSize);
        ((DrawableLaneColumnFeedback)feedback).setForeground(valid ? LaneResizeCapability.WHITE_TRANSLUCENT : LaneResizeCapability.RED_TRANSLUCENT);
        super.drag(feedback, destination, event);
    }

    @Override
    @NotNull
    protected DrawableFeedback createFeedbackImage() {
        return new DrawableLaneColumnFeedback(this.getController());
    }

    @Override
    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        DrawContext context = this.getDrawContext();
        int offsetPlusSize = context.isHorizontalDrawing() ? destination.getY() : destination.getX();
        ResizeLaneCommand result = null;
        if (this.sizeController.checkValidNewOffsetPlusSize(offsetPlusSize)) {
            Lane lane = (Lane)this.getController().getModelObject();
            result = new ResizeLaneCommand(lane, offsetPlusSize - lane.getOffset());
        }
        this.sizeController.resetMinimumSize();
        return result;
    }

    @Override
    @NotNull
    protected LaneColumnController getController() {
        return (LaneColumnController)super.getController();
    }

    private static class DrawableLaneColumnFeedback
    extends DrawableFeedback<LaneImpl> {
        private final LaneColumnController controller;
        private Color foreground;

        private DrawableLaneColumnFeedback(@NotNull LaneColumnController controller) {
            super(controller.getDrawableObject().getContainer(), (FlowElement)controller.getModelObject(), DesignerLayer.CAPABILITY);
            this.controller = controller;
        }

        public int getWidth(@NotNull DrawContext context) {
            return context.isHorizontalDrawing() ? 20000 : this.getSizeForLocation(context);
        }

        public int getHeight(@NotNull DrawContext context) {
            return context.isHorizontalDrawing() ? this.getSizeForLocation(context) : 20000;
        }

        @NotNull
        public Point getLocation() {
            DrawContext context = this.controller.getDomain().getDrawContext();
            int modelOffsetPlusSize = ((LaneImpl)this.getModelObject()).getOffset() + ((LaneImpl)this.getModelObject()).getSize();
            Point pointerLocation = super.getLocation();
            int y = context.isHorizontalDrawing() ? Math.min(modelOffsetPlusSize, pointerLocation.getY()) : 0;
            int x = context.isHorizontalDrawing() ? 0 : Math.min(modelOffsetPlusSize, pointerLocation.getX());
            return new Point(x + this.getWidth(context) / 2, y + this.getHeight(context) / 2);
        }

        public void draw(@NotNull DrawContext context) {
            Graphics graphics = context.getGraphics();
            graphics.setForeground(this.foreground);
            Rectangle bounds = context.scaleRectangle(this.getBounds(context));
            graphics.fill(bounds);
            graphics.setForeground(Color.GRAY);
            graphics.setStroke(Stroke.TWO_SOLID);
            graphics.drawLine(bounds.getX(), bounds.getY(), bounds.getX() + bounds.getWidth(), bounds.getY());
            graphics.drawLine(bounds.getX(), bounds.getY() + bounds.getHeight(), bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        }

        private int getSizeForLocation(@NotNull DrawContext context) {
            int modelOffsetPlusSize = ((LaneImpl)this.getModelObject()).getOffset() + ((LaneImpl)this.getModelObject()).getSize();
            int pointerOffsetPlusSize = context.isHorizontalDrawing() ? super.getLocation().getY() : super.getLocation().getX();
            return Math.abs(pointerOffsetPlusSize - modelOffsetPlusSize);
        }

        private void setForeground(@NotNull Color foreground) {
            this.foreground = foreground;
        }
    }

    private static class DragMinimumSizeController {
        private Lane lane;
        private int minimumValue = 200;

        private DragMinimumSizeController() {
        }

        private void setMinimumSize(@NotNull Lane lane) {
            this.minimumValue = LaneUtils.calculateMinimunLaneSize((Lane)lane, (int)200);
            this.lane = lane;
        }

        private void resetMinimumSize() {
            this.minimumValue = 200;
            this.lane = null;
        }

        private boolean checkValidNewOffsetPlusSize(int newOffsetPlusSize) {
            return this.minimumValue < newOffsetPlusSize - this.lane.getOffset();
        }
    }
}

