/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.capability.drag.ImageDraggableCapability;
import oracle.bpm.designer.controller.LaneController;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.geom.Point;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.command.design.MoveLaneCommand;
import oracle.bpm.project.model.processes.Lane;
import org.jetbrains.annotations.NotNull;

public class LaneMoveCapability
extends ImageDraggableCapability {
    public LaneMoveCapability(@NotNull LaneController controller) {
        this(CapabilityType.MOVE_LANE, controller);
    }

    protected LaneMoveCapability(@NotNull CapabilityType type, @NotNull LaneController controller) {
        super(type, controller);
    }

    @Override
    @NotNull
    protected DrawableFeedback<?> createFeedbackImage() {
        return ImageFeedback.create(this.getController().getDrawableObject());
    }

    @Override
    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        DrawableFlowElement drawable = this.getController().getDrawableObject();
        DrawContext context = this.getDrawContext();
        Point result = super.setDistanceToPointer(event);
        result = result.add(drawable.getWidth(context) / 2, drawable.getHeight(context) / 2 + ((LaneImpl)this.getController().getModelObject()).getOffset());
        result = result.add(context.unscalePoint(new Point(context.isHorizontalDrawing() ? context.getDeltaX() : 0, context.isHorizontalDrawing() ? 0 : context.getDeltaY())));
        return result;
    }

    @Override
    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        return new MoveLaneCommand((Lane)this.getController().getModelObject(), destination);
    }

    @Override
    @NotNull
    protected LaneController getController() {
        return (LaneController)super.getController();
    }
}

