/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.animation.Animator;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.CapableController;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.drag.DraggableCapability;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class ImageDraggableCapability
extends DraggableCapability {
    private Point distance = Point.ORIGIN;
    private DrawableFeedback feedback;
    private Point initial = Point.ORIGIN;

    protected ImageDraggableCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        this.feedback = this.createFeedbackImage();
        this.startDrag(this.feedback, event);
    }

    @Override
    public void drag(@NotNull CapabilityEvent event) {
        Rectangle prevDragRectangle = this.getDrawContext().scaleRectangle(this.buildFeedbackDirtyRegionRectangle());
        this.drag(this.feedback, this.getDestination(event.getLocation()), event);
        Rectangle postDragRectangle = this.getDrawContext().scaleRectangle(this.buildFeedbackDirtyRegionRectangle());
        Rectangle repaintRegion = prevDragRectangle.union(postDragRectangle).expand(2);
        this.getDomain().getCanvas().paintImmediately(repaintRegion);
    }

    @Override
    public void endDrag(@NotNull CapabilityEvent event) {
        this.drop(this.feedback, this.getDestination(event.getLocation()), event);
        Rectangle rectangle = this.getDrawContext().scaleRectangle(this.buildFeedbackDirtyRegionRectangle());
        this.getDomain().getCanvas().paintImmediately(rectangle);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        return this.process(this.getDestination(event.getLocation()), event);
    }

    @Override
    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        if (this.feedback != null) {
            Animator.move(this.getDomain(), this.feedback, this.initial, 3);
            this.dragging = false;
        }
    }

    @NotNull
    protected abstract DrawableFeedback createFeedbackImage();

    protected abstract Command process(@NotNull Point var1, @NotNull CapabilityEvent var2);

    protected void startDrag(@NotNull DrawableFeedback feedback, @NotNull CapabilityEvent event) {
        feedback.add();
        this.distance = this.setDistanceToPointer(event);
        this.initial = this.getDestination(event.getLocation());
    }

    protected void drag(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.setLocation(destination);
    }

    protected void drop(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.remove();
    }

    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return this.feedback.getLocation().sub(event.getLocation());
    }

    @NotNull
    protected Point getDestination(@NotNull Point pointer) {
        return pointer.add(this.distance);
    }

    protected Rectangle buildFeedbackDirtyRegionRectangle() {
        return this.feedback.getBounds(this.getDrawContext());
    }

    protected final DrawContext getDrawContext() {
        return this.getDomain().getDrawContext();
    }
}

