/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.drag.NodeMoveCapability;
import oracle.bpm.designer.controller.EventController;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

public class EventMoveCapability
extends NodeMoveCapability {
    public EventMoveCapability(@NotNull EventController controller) {
        super(controller);
    }

    protected EventMoveCapability(@NotNull CapabilityType type, @NotNull EventController controller) {
        super(type, controller);
    }

    @Override
    protected void drag(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateTargetAndDestination(destination, event);
        super.drag(feedback, location, event);
    }

    @Override
    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateTargetAndDestination(destination, event);
        return super.process(location, event);
    }

    private Point updateTargetAndDestination(Point destination, CapabilityEvent event) {
        Point location = destination;
        BoundaryEvent boundary = (BoundaryEvent)((Event)this.getEventController().getModelObject()).asAnyNode(BoundaryEvent.class);
        if (boundary != null) {
            this.updateTarget(boundary, event);
            location = this.getBoundedLocation(destination, event);
        }
        return location;
    }

    private FlowElementController updateTarget(BoundaryEvent boundary, CapabilityEvent event) {
        FlowElementController target = this.getEventController().getContainer().asController((FlowElement)boundary.getBoundaryActivity());
        event.setTarget(target);
        return target;
    }

    private Point getBoundedLocation(@NotNull Point destination, @NotNull CapabilityEvent event) {
        return DrawableEvent.calculateLocationFromActivity((DrawContext)this.getDrawContext(), event.getTarget().getDrawableObject(), (Point)destination);
    }

    private EventController getEventController() {
        return (EventController)this.getController();
    }
}

