/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.drag.DraggableCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.subcontroller.ResizeSubcontroller;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ElementResizeCapability
extends DraggableCapability {
    protected Rectangle minimum = Rectangle.ZERO;

    protected ElementResizeCapability(@NotNull ResizeSubcontroller controller) {
        this(CapabilityType.RESIZE, controller);
    }

    protected ElementResizeCapability(@NotNull CapabilityType type, @NotNull ResizeSubcontroller controller) {
        super(type, controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
    }

    @Override
    public void drag(@NotNull CapabilityEvent event) {
        Drawable drawable = this.getParentController().getDrawableObject();
        DrawContext context = this.getDrawContext();
        Rectangle prev = drawable.getBounds(context);
        Rectangle bounds = this.getResizeBounds(event);
        drawable.setLocation(bounds.getCenter());
        drawable.setWidth(context, bounds.getWidth());
        drawable.setHeight(context, bounds.getHeight());
        Rectangle dirty = prev.union(bounds).expand(6).translate(4, 4);
        this.getDomain().getCanvas().paintImmediately(dirty.scaled(context.getScale()));
    }

    @Override
    public void endDrag(@NotNull CapabilityEvent event) {
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        return null;
    }

    protected Rectangle getResizeBounds(@NotNull CapabilityEvent event) {
        Point top = this.minimum.getTop().max(event.getLocation());
        return Rectangle.deriveFromPoints(this.minimum.getOrigin(), top);
    }

    protected Controller getParentController() {
        return this.getController().getContainer();
    }

    protected DrawContext getDrawContext() {
        return this.getDomain().getDrawContext();
    }
}

