/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.drag.DraggableCapability;
import oracle.bpm.designer.controller.ConnectionController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.subcontroller.AnchorSubcontroller;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableConnection;
import oracle.bpm.draw.DrawableConnectionImpl;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.QuadCurve;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.ChangeSequenceFlowRoutingDataCommand;
import oracle.bpm.project.command.design.ChangeTransitionSourceCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.policies.SequenceFlowPolicies;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class AnchorMoveCapability
extends DraggableCapability {
    private ConnectionFeedback connection;

    public AnchorMoveCapability(@NotNull AnchorSubcontroller controller) {
        super(controller);
    }

    public static FlowNodeController getValidTarget(@NotNull CapabilityEvent event, @NotNull ConnectionController sequenceController) {
        HighlightSubcontroller highlight;
        FlowNodeController targetController;
        FlowNodeController flowNodeController = targetController = event.getTarget() instanceof FlowNodeController ? (FlowNodeController)event.getTarget() : null;
        if (targetController == null && event.getTarget() instanceof HighlightSubcontroller && (highlight = (HighlightSubcontroller)event.getTarget()).getContainer() instanceof FlowNodeController) {
            targetController = (FlowNodeController)highlight.getContainer();
        }
        FlowNodeController sourceController = (FlowNodeController)sequenceController.getSourceController();
        if (targetController != null && sourceController != null) {
            try {
                SequenceFlowPolicies.checkSequenceFlow(sourceController.getModelObject(), targetController.getModelObject(), (boolean)((SequenceFlow)((SequenceFlowController)sequenceController).getModelObject()).isConditionalFlow(), (boolean)false);
            }
            catch (ProjectException e) {
                targetController = null;
            }
        } else if (targetController != null && !ModelUtils.shouldHaveOutgoingSequenceFlow(targetController.getModelObject())) {
            targetController = null;
        }
        return targetController;
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        this.getDomain().getSelectionProvider().setSelection(this.getConnectionController());
        this.connection = this.createConnectionFeedback();
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        this.connection.update(event, this.getDrawContext(), this.getController().getAnchor());
        this.connection.add();
    }

    @Override
    public void drag(@NotNull CapabilityEvent event) {
        DrawContext context = this.getDrawContext();
        Rectangle prev = this.connection.getBounds(context);
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        this.connection.update(event, context, this.getController().getAnchor());
        Rectangle post = this.connection.getBounds(context);
        Rectangle union = prev.union(post).expand(10);
        this.getDomain().getCanvas().paintImmediately(context.scaleRectangle(union));
    }

    @Override
    public void endDrag(@NotNull CapabilityEvent event) {
        this.connection.remove();
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        ChangeTransitionSourceCommand result = null;
        FlowNodeController target = AnchorMoveCapability.getValidTarget(event, this.getConnectionController());
        SequenceFlow flow = (SequenceFlow)this.getConnectionController().getModelObject();
        switch (this.getController().getAnchor()) {
            case FROM: {
                if (target == null) break;
                result = new ChangeTransitionSourceCommand(flow, target.getModelObject());
                break;
            }
            case TO: {
                if (target == null) break;
                result = new ChangeTransitionTargetCommand(flow, target.getModelObject());
                break;
            }
            default: {
                Point ctrl = event.getLocation();
                if (flow.getRoutingMode() == RoutingMode.CURVED) {
                    ctrl = QuadCurve.calculateControlPoint(flow.getSource().getLocation(), ctrl, flow.getTarget().getLocation());
                }
                result = new ChangeSequenceFlowRoutingDataCommand(flow, flow.getRoutingMode(), ctrl);
            }
        }
        return result;
    }

    @Override
    public void eraseTargetVisuals(@NotNull CapabilityEvent event) {
        this.getController().getDomain().getCanvas().setCursor(Cursor.DEFAULT_CURSOR);
        super.eraseTargetVisuals(event);
    }

    @Override
    @NotNull
    protected AnchorSubcontroller getController() {
        return (AnchorSubcontroller)super.getController();
    }

    private DrawContext getDrawContext() {
        return this.getDomain().getDrawContext();
    }

    private ConnectionController getConnectionController() {
        return this.getController().getContainer();
    }

    private DrawableConnection getDrawableConnection() {
        return this.getConnectionController().getDrawableObject();
    }

    private ConnectionFeedback createConnectionFeedback() {
        Point ctrl;
        Drawable target;
        ConnectionFeedback result = new ConnectionFeedback(this.getConnectionContainer(), this.getConnectionController());
        Drawable source = this.getDrawableConnection().getDrawableSource();
        if (source != null) {
            result.setDrawableSource(this.getDrawContext(), source);
        }
        if ((target = this.getDrawableConnection().getDrawableTarget()) != null) {
            result.setDrawableTarget(this.getDrawContext(), target);
        }
        if (!(ctrl = this.getDrawableConnection().getControlPoint()).equals(SequenceFlow.NULL_CONTROL_POINT)) {
            result.setControlPointLocation(this.getDrawContext(), ctrl);
        }
        return result;
    }

    private NodeContainerController getConnectionContainer() {
        return (NodeContainerController)this.getConnectionController().getContainer();
    }

    public static class ConnectionFeedback
    extends DrawableConnectionImpl<Object> {
        private final ConnectionController connectionController;

        public ConnectionFeedback(@NotNull NodeContainerController container, @NotNull ConnectionController connectionController) {
            super(container.getDrawableObject(), connectionController.getModelObject(), DesignerLayer.CAPABILITY);
            this.connectionController = connectionController;
        }

        public void update(@NotNull CapabilityEvent event, @NotNull DrawContext context, @NotNull DrawableHelper.TransitionAnchor anchor) {
            FlowNodeController controller = AnchorMoveCapability.getValidTarget(event, this.connectionController);
            switch (anchor) {
                case FROM: {
                    if (controller != null) {
                        this.setDrawableSource(context, (Drawable)controller.getDrawableObject());
                        controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                        break;
                    }
                    this.setSourceLocation(context, event.getLocation());
                    break;
                }
                case TO: {
                    if (controller != null) {
                        this.setDrawableTarget(context, (Drawable)controller.getDrawableObject());
                        controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                        break;
                    }
                    this.setTargetLocation(context, event.getLocation());
                    break;
                }
                default: {
                    this.connectionController.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                    SequenceFlow flow = (SequenceFlow)this.connectionController.getModelObject();
                    Point ctrl = event.getLocation();
                    if (flow.getRoutingMode() == RoutingMode.CURVED) {
                        ctrl = QuadCurve.calculateControlPoint(flow.getSource().getLocation(), event.getLocation(), flow.getTarget().getLocation());
                    }
                    if (flow.getRoutingMode() == RoutingMode.STRAIGHT) {
                        flow.setRoutingData(RoutingMode.ORTHOGONAL, ctrl);
                    }
                    this.setControlPointLocation(context, ctrl);
                }
            }
        }
    }
}

