/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.capability.add.ImageAddingCapability;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddNoteCommand;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class ProcessAddNoteCapability
extends ImageAddingCapability {
    public ProcessAddNoteCapability(@NotNull ProcessController container) {
        super(CapabilityType.ADD_NOTE, container);
    }

    @Override
    @NotNull
    protected DrawableFeedback createFeedbackImage(CapabilityEvent event) {
        return ImageFeedback.create(this.getNoteController(event).getDrawableObject(), this.getDrawContext());
    }

    @Override
    protected void startAdd(@NotNull DrawableFeedback feedback, @NotNull CapabilityEvent event) {
        this.getDomain().getCanvas().setCursor(Cursor.TEXT_CURSOR);
        super.startAdd(feedback, event);
    }

    @Override
    protected void endAdd(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        this.getDomain().getCanvas().setCursor(Cursor.DEFAULT_CURSOR);
        super.endAdd(feedback, destination, event);
    }

    @Override
    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        return new AddNoteCommand((TextAnnotation)this.getNoteController(event).getModelObject(), destination.getX(), destination.getY());
    }

    @Override
    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return Point.ORIGIN;
    }

    private NoteController getNoteController(@NotNull CapabilityEvent event) {
        return (NoteController)event.getAdding();
    }
}

