/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.collections.Tuple;
import oracle.bpm.command.Command;
import oracle.bpm.designer.action.AddLaneAction;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.ConnectionVisuals;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.capability.add.ImageAddingCapability;
import oracle.bpm.designer.command.EnsureLaneCommand;
import oracle.bpm.designer.command.SmartAddActivityCommand;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.processdesigner.states.AddingSequenceFlowState;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class ProcessAddNodeCapability
extends ImageAddingCapability {
    private Tuple<NodeContainerController, FlowNode> consolidation = null;
    private ConnectionVisuals updater = this.createConnectionVisuals();

    public ProcessAddNodeCapability(@NotNull NodeContainerController container) {
        this(CapabilityType.ADD_NODE, container);
    }

    protected ProcessAddNodeCapability(@NotNull CapabilityType type, @NotNull NodeContainerController container) {
        super(type, container);
    }

    @Override
    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.cancelAnyVisuals(event);
    }

    @Override
    public void consolidate(@NotNull CapabilityEvent event) {
        super.consolidate(event);
        if (this.consolidation != null) {
            AddingSequenceFlowState state = AddingSequenceFlowState.create(this.consolidation.getFirst(), this.consolidation.getSecond(), TransitionType.UNCONDITIONAL);
            this.getDomain().getStateManager().setCurrentState(state);
            this.consolidation = null;
        }
    }

    protected ConnectionVisuals createConnectionVisuals() {
        return new ConnectionVisuals(false);
    }

    @Override
    @NotNull
    protected DrawableFeedback createFeedbackImage(@NotNull CapabilityEvent event) {
        FlowNodeController controller = this.getFlowNodeControllerFromEvent(event);
        controller.refresh();
        DrawableFlowElement drawable = controller.getDrawableObject();
        return ImageFeedback.create(drawable);
    }

    @Override
    protected void updateAdd(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateTargetAndDestination(destination, event);
        super.updateAdd(feedback, location, event);
    }

    @Override
    protected void endAdd(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.endAdd(feedback, destination, event);
    }

    @Override
    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        SmartAddActivityCommand result;
        Point location = this.updateTargetAndDestination(destination, event);
        FlowNodeController adding = this.getFlowNodeControllerFromEvent(event);
        Object flowNode = adding.getModelObject();
        Object container = this.getController().getModelObject();
        if (this.isValidBoundaryInsertion(event.getTarget(), adding)) {
            FlowNodeController target = (FlowNodeController)event.getTarget();
            EventTriggerType trigger = ((Event)flowNode.asAnyNode(Event.class)).getEventTriggerType();
            flowNode = FlowFigureUtils.createBoundaryEventFromFigureType((EventTriggerType)trigger, (Activity)((Activity)target.getModelObject()), target.getContainer().getModelObject());
            this.consolidation = Tuple.create(target.getContainer(), flowNode);
        } else if (!flowNode.getParentObject().equals(container)) {
            FlowFigureType type = FlowFigureUtils.fromElement(flowNode);
            flowNode = FlowFigureUtils.createNodeFromFigureType((FlowFigureType)type, container);
        }
        if (this.showProperties((FlowNode)flowNode)) {
            SequenceFlowController target;
            AddLaneAction.LaneInfo lane = null;
            boolean needs = EnsureLaneCommand.needsNewLane(location, flowNode);
            if (needs) {
                lane = AddLaneAction.newLaneName(container.getProcess(), false, ModelUtils.canBeInParametricRole(flowNode));
            }
            SequenceFlowController sequenceFlowController = target = event.getTarget() instanceof SequenceFlowController ? (SequenceFlowController)event.getTarget() : null;
            result = !needs || lane != null ? new SmartAddActivityCommand((FlowNode)flowNode, lane, location, target != null ? (SequenceFlow)target.getModelObject() : null) : null;
        } else {
            result = null;
        }
        this.updater.resetCurrentTarget();
        if (result != null && DesignerPreferences.getPreferences().isAutoLayout()) {
            MultipleCommand multiple = new MultipleCommand(new ProjectObject[]{container.getProcess()});
            multiple.addCommand(result);
            multiple.addCommand((Command)new LayoutModelCommand(container.getProcess(), DesignerPreferences.getPreferences().isOptimizeLanesOnAutoLayout()));
            result = multiple;
        }
        return result;
    }

    @Override
    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return Point.ORIGIN;
    }

    @Override
    @NotNull
    protected NodeContainerController getController() {
        return (NodeContainerController)super.getController();
    }

    private Point updateTargetAndDestination(@NotNull Point destination, @NotNull CapabilityEvent event) {
        Controller<?> target = event.getTarget();
        Point location = destination;
        if (!(target instanceof SequenceFlowController)) {
            FlowNodeController flowNodeController = this.getFlowNodeControllerFromEvent(event);
            if (this.isValidBoundaryInsertion(target, flowNodeController)) {
                location = DrawableEvent.calculateLocationFromActivity((DrawContext)this.getDrawContext(), event.getTarget().getDrawableObject(), (Point)destination);
            } else if (ModelUtils.canBeInsertedInATransition(flowNodeController.getModelObject(), (boolean)event.getEvent().isShiftDown())) {
                SequenceFlowController closest = ControllerUtils.getClosestTransition(flowNodeController, this.getController(), destination, event.getEvent().isShiftDown(), false);
                event.setTarget(closest);
            }
        }
        this.updater.updateWithTarget(event, (FlowNode)event.getAdding().getModelObject());
        return location;
    }

    private boolean isValidBoundaryInsertion(Controller<?> target, @NotNull FlowNodeController controller) {
        boolean result = target instanceof FlowNodeController && ((FlowNodeController)target).getModelObject().isActivity();
        return result &= controller.getModelObject().isEvent() && ((Event)controller.getModelObject().asAnyNode(Event.class)).isCatchEvent() && ((Event)controller.getModelObject().asAnyNode(Event.class)).isIntermediate();
    }

    private boolean showProperties(@NotNull FlowNode flowNode) {
        boolean result = true;
        if (DesignerPreferences.getPreferences().showPropertiesAutomaticallyWhenAddingActivity() && !ModelUtils.isSubprocess((FlowNode)flowNode)) {
            result = FlowNodePropertiesDialog.editProperties(flowNode);
        }
        return result;
    }

    private FlowNodeController getFlowNodeControllerFromEvent(@NotNull CapabilityEvent event) {
        return (FlowNodeController)event.getAdding();
    }
}

