/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.designer.animation.Animator;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.CapableController;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.add.AddingCapability;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.PaintCanvas;
import org.jetbrains.annotations.NotNull;

public abstract class ImageAddingCapability
extends AddingCapability {
    private Point distance = Point.ORIGIN;
    private DrawableFeedback feedback;
    private Point initial = Point.ORIGIN;

    protected ImageAddingCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    @Override
    public void startAdd(@NotNull CapabilityEvent event) {
        this.feedback = this.createFeedbackImage(event);
        this.startAdd(this.feedback, event);
    }

    @Override
    public void updateAdd(@NotNull CapabilityEvent event) {
        Rectangle prevDragRectangle = this.getDrawContext().scaleRectangle(this.buildFeedbackDirtyRegionRectangle());
        this.updateAdd(this.feedback, this.getDestination(event.getLocation()), event);
        Rectangle postDragRectangle = this.getDrawContext().scaleRectangle(this.buildFeedbackDirtyRegionRectangle());
        Rectangle repaintRegion = prevDragRectangle.union(postDragRectangle).expand(2);
        this.getCanvas().paintImmediately(repaintRegion);
    }

    @Override
    public void endAdd(@NotNull CapabilityEvent event) {
        this.endAdd(this.feedback, this.getDestination(event.getLocation()), event);
        this.getCanvas().paintImmediately(this.buildFeedbackDirtyRegionRectangle());
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        return this.process(this.getDestination(event.getLocation()), event);
    }

    @Override
    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        if (this.feedback != null) {
            Animator.move(this.getDomain(), this.feedback, this.initial, 3);
            this.adding = false;
        }
    }

    @NotNull
    protected abstract DrawableFeedback createFeedbackImage(CapabilityEvent var1);

    protected abstract Command process(@NotNull Point var1, @NotNull CapabilityEvent var2);

    protected void startAdd(@NotNull DrawableFeedback feedback, @NotNull CapabilityEvent event) {
        feedback.add();
        this.distance = this.setDistanceToPointer(event);
        this.initial = this.getDestination(event.getLocation());
    }

    protected void updateAdd(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.setLocation(destination);
    }

    protected void endAdd(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.remove();
    }

    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return this.feedback.getLocation().sub(event.getLocation());
    }

    @NotNull
    protected Point getDestination(@NotNull Point pointer) {
        return pointer.add(this.distance);
    }

    protected Rectangle buildFeedbackDirtyRegionRectangle() {
        return this.feedback.getBounds(this.getDrawContext());
    }

    protected final DrawContext getDrawContext() {
        return this.getDomain().getDrawContext();
    }

    protected final PaintCanvas getCanvas() {
        return this.getDomain().getCanvas();
    }
}

