/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.add.AddingCapability;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.processdesigner.states.AddingSequenceFlowState;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.process.policies.SequenceFlowPolicies;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class ContainerAddingSequenceFlowCapability
extends AddingCapability {
    public ContainerAddingSequenceFlowCapability(@NotNull NodeContainerController container) {
        super(CapabilityType.ADD_CONNECTION, container);
    }

    @Override
    public void startAdd(@NotNull CapabilityEvent event) {
        this.updateConnectionFeedback(event);
        this.getDrawableConnectionFeedback(event).add();
        this.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
    }

    public void updateSource(@NotNull CapabilityEvent event) {
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        this.update(event, this.getDrawContext(), DrawableHelper.TransitionAnchor.FROM);
    }

    @Override
    public void updateAdd(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
        Drawable source = connection.getDrawableSource();
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        if (source != null) {
            DrawContext context = this.getDrawContext();
            Rectangle prev = connection.getBounds(context);
            this.updateConnectionFeedback(event);
            Rectangle post = connection.getBounds(context);
            Rectangle union = prev.union(post).expand(10);
            this.getDomain().getCanvas().paintImmediately(context.scaleRectangle(union));
        } else if (this.getValidTarget(event, DrawableHelper.TransitionAnchor.FROM) != null) {
            this.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
        }
    }

    @Override
    public void endAdd(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
        Rectangle bounds = connection.getBounds(this.getDrawContext());
        connection.remove();
        this.getDomain().getCanvas().paintImmediately(this.getDrawContext().scaleRectangle(bounds.expand(10)));
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
        Drawable drawableSource = connection.getDrawableSource();
        Drawable drawableTarget = connection.getDrawableTarget();
        if (drawableSource != null && drawableTarget != null) {
            FlowNode source = (FlowNode)drawableSource.getModelObject();
            FlowNode target = (FlowNode)drawableTarget.getModelObject();
            Object container = this.getController().getModelObject();
            if (container.equals(target)) {
                container = target.getParentObject();
            }
            if (container.equals(source)) {
                container = source.getParentObject();
            }
            SequenceFlow flow = container.createSequenceFlow(source, target);
            if (((SequenceFlow)connection.getModelObject()).isConditionalFlow()) {
                flow.toConditionalFlow();
            }
            return new AddTransitionCommand(flow);
        }
        return null;
    }

    @Override
    public void eraseTargetVisuals(@NotNull CapabilityEvent event) {
        this.getController().getDomain().getCanvas().setCursor(Cursor.DEFAULT_CURSOR);
        this.getDrawableConnectionFeedback(event).remove();
        super.eraseTargetVisuals(event);
    }

    public boolean isSourceDefined(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback feedback = this.getDrawableConnectionFeedback(event);
        return feedback.getDrawableSource() != null;
    }

    public void update(@NotNull CapabilityEvent event, @NotNull DrawContext context, @NotNull DrawableHelper.TransitionAnchor anchor) {
        FlowNodeController controller = this.getValidTarget(event, anchor);
        AddingSequenceFlowState.DrawableConnectionFeedback feedback = this.getDrawableConnectionFeedback(event);
        switch (anchor) {
            case FROM: {
                if (controller != null) {
                    feedback.setDrawableSource(context, (Drawable)controller.getDrawableObject());
                    controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                    break;
                }
                feedback.setSourceLocation(context, event.getLocation());
                break;
            }
            case TO: {
                if (controller != null) {
                    feedback.setDrawableTarget(context, (Drawable)controller.getDrawableObject());
                    controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                    break;
                }
                feedback.setTargetLocation(context, event.getLocation());
                break;
            }
            default: {
                feedback.setControlPointLocation(context, event.getLocation());
            }
        }
    }

    @Override
    @NotNull
    protected NodeContainerController getController() {
        return (NodeContainerController)super.getController();
    }

    private void updateConnectionFeedback(@NotNull CapabilityEvent event) {
        if (this.isSourceDefined(event)) {
            this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
            this.update(event, this.getDrawContext(), DrawableHelper.TransitionAnchor.TO);
        }
    }

    private AddingSequenceFlowState.DrawableConnectionFeedback getDrawableConnectionFeedback(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.ControllerConnectionFeedback controller = (AddingSequenceFlowState.ControllerConnectionFeedback)event.getAdding();
        return controller.getDrawableObject();
    }

    private DrawContext getDrawContext() {
        return this.getDomain().getDrawContext();
    }

    private FlowNodeController getValidTarget(@NotNull CapabilityEvent event, DrawableHelper.TransitionAnchor anchor) {
        HighlightSubcontroller highlight;
        FlowNodeController controller;
        FlowNodeController flowNodeController = controller = event.getTarget() instanceof FlowNodeController ? (FlowNodeController)event.getTarget() : null;
        if (controller == null && event.getTarget() instanceof HighlightSubcontroller && (highlight = (HighlightSubcontroller)event.getTarget()).getContainer() instanceof FlowNodeController) {
            controller = (FlowNodeController)highlight.getContainer();
        }
        if (controller != null) {
            switch (anchor) {
                case FROM: {
                    if (SequenceFlowPolicies.isValidNewSequenceFlowSource(controller.getModelObject())) break;
                    controller = null;
                    break;
                }
                case TO: {
                    AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
                    FlowNode source = (FlowNode)connection.getDrawableSource().getModelObject();
                    Object target = controller.getModelObject();
                    boolean conditional = ((SequenceFlow)connection.getModelObject()).isConditionalFlow();
                    if (SequenceFlowPolicies.isValidNewSequenceFlowSourceAndTarget((FlowNode)source, target, (boolean)conditional)) break;
                    controller = null;
                }
            }
        }
        return controller;
    }
}

