/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.CapableController;
import oracle.bpm.designer.capability.ConnectionVisuals;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.capability.add.ImageAddingCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.MeasurementController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddMeasurementCommand;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class ContainerAddMeasurementCapability
extends ImageAddingCapability {
    private ConnectionVisuals updater = this.createConnectionVisuals();

    public ContainerAddMeasurementCapability(@NotNull NodeContainerController container) {
        this(CapabilityType.ADD_MEASUREMENT, container);
    }

    protected ContainerAddMeasurementCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    @Override
    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.cancelAnyVisuals(event);
    }

    @Override
    protected void updateAdd(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        this.updateTarget(event);
        super.updateAdd(feedback, destination, event);
    }

    @Override
    protected void endAdd(@NotNull DrawableFeedback feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.endAdd(feedback, destination, event);
    }

    protected ConnectionVisuals createConnectionVisuals() {
        return new ConnectionVisuals(false);
    }

    @Override
    @NotNull
    protected DrawableFeedback createFeedbackImage(CapabilityEvent event) {
        FlowElementController controller = this.getAddingControllerFromEvent(event);
        controller.refresh();
        DrawableFlowElement drawable = controller.getDrawableObject();
        return ImageFeedback.create(drawable);
    }

    @Override
    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        this.updateTarget(event);
        SequenceFlow target = event.getTarget() instanceof SequenceFlowController ? (SequenceFlow)((SequenceFlowController)event.getTarget()).getModelObject() : null;
        AddMeasurementCommand result = null;
        if (target != null) {
            Measurement measurement = (Measurement)this.getMeasurementControllerFromEvent(event).getModelObject();
            if (!measurement.getParentObject().equals(this.getController().getModelObject())) {
                FlowFigureType type = FlowFigureUtils.fromElement((FlowElement)measurement);
                measurement = (Measurement)FlowFigureUtils.createArtifactFromFigureType((FlowFigureType)type, this.getController().getModelObject());
            }
            result = new AddMeasurementCommand(measurement, target, event.getLocation());
        }
        this.updater.resetCurrentTarget();
        return result;
    }

    @Override
    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return Point.ORIGIN;
    }

    @Override
    @NotNull
    protected NodeContainerController getController() {
        return (NodeContainerController)super.getController();
    }

    private MeasurementController getMeasurementControllerFromEvent(CapabilityEvent event) {
        return (MeasurementController)event.getAdding();
    }

    private FlowElementController getAddingControllerFromEvent(CapabilityEvent event) {
        return (FlowElementController)event.getAdding();
    }

    private void updateTarget(@NotNull CapabilityEvent event) {
        Controller<?> target = event.getTarget();
        if (!(target instanceof SequenceFlowController)) {
            SequenceFlowController closest = ControllerUtils.getClosestTransition(this.getController(), event.getLocation(), event.getEvent().isShiftDown(), false);
            event.setTarget(closest);
        }
        this.updater.updateWithTarget(event);
    }
}

