/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability;

import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ImageFeedback<T extends FlowElement>
extends DrawableFeedback<T> {
    private Image image;

    private ImageFeedback(@NotNull Drawable<?> container, @NotNull DrawableFlowElement<T> drawable, @NotNull DesignerLayer layer) {
        this(container, drawable, layer, DrawContext.getDefault());
    }

    private ImageFeedback(@NotNull Drawable<?> container, @NotNull DrawableFlowElement<T> drawable, @NotNull DesignerLayer layer, @NotNull DrawContext context) {
        super(container, drawable.getModelObject(), layer);
        this.image = this.createImage(drawable, context);
    }

    public static <T extends FlowElement> ImageFeedback<T> create(@NotNull DrawableFlowElement<T> drawable) {
        return new ImageFeedback<T>(drawable.getContainer(), drawable, DesignerLayer.CAPABILITY);
    }

    public static <T extends FlowElement> ImageFeedback<T> create(@NotNull DrawableFlowElement<T> drawable, @NotNull DrawContext context) {
        return new ImageFeedback<T>(drawable.getContainer(), drawable, DesignerLayer.CAPABILITY, context);
    }

    public int getWidth(@NotNull DrawContext context) {
        return this.image.getWidth();
    }

    public int getHeight(@NotNull DrawContext context) {
        return this.image.getHeight();
    }

    public void draw(@NotNull DrawContext context) {
        Rectangle bounds = context.scaleRectangle(this.getBounds(context));
        Graphics graphics = context.getGraphics();
        Color original = graphics.getForeground();
        graphics.setForeground(Color.TRANSLUCENT);
        graphics.drawImage(this.image, bounds);
        graphics.setForeground(original);
    }

    private Image createImage(@NotNull DrawableFlowElement<T> drawable, @NotNull DrawContext context) {
        return DrawableHelper.createImageForDrawable(drawable, (DrawContext)context);
    }
}

