/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability;

import oracle.bpm.designer.capability.Capability;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.CapableController;
import oracle.bpm.designer.capability.SpecifiedResult;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.RootController;
import org.jetbrains.annotations.NotNull;

public class CapabilityHelper {
    public static SpecifiedResult specify(@NotNull Controller<?> controller, @NotNull CapabilityType type) {
        SpecifiedResult result = null;
        if (controller instanceof CapableController) {
            CapableController capable = (CapableController)controller;
            for (Capability capability : capable.capabilities()) {
                CapabilityType specific = capability.specify(type);
                if (specific == null) continue;
                result = SpecifiedResult.create(capability, specific);
                break;
            }
        }
        if (result == null && !(controller.getContainer() instanceof RootController)) {
            result = CapabilityHelper.specify(controller.getContainer(), type);
        }
        return result;
    }
}

