/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability;

import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.SpecifiedResult;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityEvent {
    private Controller<?> adding;
    private MouseEvent event;
    private final Point location;
    private Controller<?> owner;
    private Controller<?> target;
    private final CapabilityType type;

    private CapabilityEvent(@NotNull SpecifiedResult specified, @NotNull Point location, @Nullable MouseEvent event) {
        this.type = specified.getSpecified();
        this.owner = specified.getOwner();
        this.adding = specified.getAdding();
        this.location = location;
        this.event = event;
    }

    public static CapabilityEvent create(@NotNull SpecifiedResult specified, @NotNull Point location, @NotNull MouseEvent event) {
        return new CapabilityEvent(specified, location, event);
    }

    public static CapabilityEvent create(@NotNull SpecifiedResult specified, @NotNull Point location) {
        return new CapabilityEvent(specified, location, null);
    }

    public MouseEvent getEvent() {
        return this.event;
    }

    public CapabilityType getType() {
        return this.type;
    }

    public Point getLocation() {
        return this.location;
    }

    public Controller<?> getOwner() {
        return this.owner;
    }

    public Controller<?> getTarget() {
        return this.target;
    }

    public Controller<?> getAdding() {
        return this.adding;
    }

    public void setTarget(Controller<?> target) {
        this.target = target;
    }
}

