/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability;

import oracle.bpm.command.Command;
import oracle.bpm.designer.Domain;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.CapableController;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Capability {
    protected final CapabilityType type;
    private final CapableController controller;
    private boolean specifyParent = true;

    protected Capability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        this.type = type;
        this.controller = controller;
    }

    @Nullable
    public abstract Command process(@NotNull CapabilityEvent var1);

    public void activate() {
    }

    public void deactivate() {
    }

    public void showSourceVisuals(@NotNull CapabilityEvent event) {
    }

    public void eraseSourceVisuals(@NotNull CapabilityEvent event) {
    }

    public void showTargetVisuals(@NotNull CapabilityEvent event) {
    }

    public void eraseTargetVisuals(@NotNull CapabilityEvent event) {
    }

    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.eraseSourceVisuals(event);
        this.eraseTargetVisuals(event);
        this.getDomain().getCanvas().repaint();
    }

    @Nullable
    public CapabilityType specify(@NotNull CapabilityType type) {
        return this.getType() == type || this.isSpecifyParent() && this.getType().hasAnyParent(type) ? this.getType() : null;
    }

    public void setSpecifyParent(boolean specifyParent) {
        this.specifyParent = specifyParent;
    }

    public void consolidate(@NotNull CapabilityEvent event) {
        this.getDomain().getSelectionProvider().clear();
        this.getDomain().getStateManager().setDefaultState();
    }

    @NotNull
    protected final CapabilityType getType() {
        return this.type;
    }

    @NotNull
    protected CapableController getController() {
        return this.controller;
    }

    @NotNull
    protected Domain getDomain() {
        return this.controller.getDomain();
    }

    private boolean isSpecifyParent() {
        return this.specifyParent;
    }
}

