/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.transformation;

import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSetType;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.ui.table.ProviderTableModel;
import org.jetbrains.annotations.NotNull;

public class DataTransformationsTableModel
extends ProviderTableModel<DataTransformation> {
    private DataAssociationSet dataAssociationSet;
    private static final MsgList titles = MsgList.create(DesignerMsg.NAME, DesignerMsg.TARGET);

    DataTransformationsTableModel(@NotNull DataAssociationSet dataAssociationSet) {
        super(titles);
        this.dataAssociationSet = dataAssociationSet;
        this.setItems(dataAssociationSet.getDataTransformations());
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        DataTransformation dataTransformation = (DataTransformation)this.getRow(row);
        switch (column) {
            case 0: {
                return dataTransformation.getTransformationName();
            }
            case 1: {
                return dataTransformation.getTargetRef();
            }
        }
        return "";
    }

    public void setItems(@NotNull Sequence<DataTransformation> items) {
        this.removeAllElements();
        for (DataTransformation item : items) {
            this.addRow(item);
        }
    }

    public DataDeclarationContainer getSourcesContainer() {
        DataAssociationItemEndpoint endpoint = this.dataAssociationSet.getType() == DataAssociationSetType.OUTPUT ? DataAssociationItemEndpoint.CUSTOM_SOURCE : DataAssociationItemEndpoint.SOURCE;
        return this.dataAssociationSet.getContextProvider(endpoint).getDataDeclarationContainer();
    }

    public DataDeclarationContainer getTargetsContainer() {
        DataAssociationItemEndpoint endpoint = this.dataAssociationSet.getType() == DataAssociationSetType.OUTPUT ? DataAssociationItemEndpoint.CUSTOM_TARGET : DataAssociationItemEndpoint.TARGET;
        return this.dataAssociationSet.getContextProvider(endpoint).getDataDeclarationContainer();
    }

    public DataTransformation createTransformation(@NotNull Sequence<String> sourceRefs, @NotNull String targetRef, @NotNull String transformationName) {
        return this.dataAssociationSet.createDataTransformation(sourceRefs, targetRef, transformationName);
    }

    public Project getProject() {
        return this.dataAssociationSet.getDataObjectsContainer().getProject();
    }
}

