/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.transformation;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.argumentmapping.transformation.DataTransformationsTableModel;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class DataTransformationsTable
extends BaseTablePanel {
    public DataTransformationsTable(@NotNull UiContainer parent, @NotNull DataAssociationSet dataAssociationSet) {
        super(parent, null, null, (TableModel)new DataTransformationsTableModel(dataAssociationSet), BaseTablePanel.Style.TOOLBAR_TOP);
    }

    public Sequence<DataTransformation> getDataTransformations() {
        return CollectionUtils.asSequence(this.getDataTransformationsTableModel().getData());
    }

    protected void addAction() {
        this.showDialog(null);
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void editAction() {
        int selectedItem = this.getTable().getSelectedRow();
        DataTransformation selectedTransformation = (DataTransformation)this.getDataTransformationsTableModel().getRow(selectedItem);
        this.showDialog(selectedTransformation);
    }

    private DataTransformationsTableModel getDataTransformationsTableModel() {
        return (DataTransformationsTableModel)super.getModel();
    }

    private void showDialog(DataTransformation selectedTransformation) {
        Dialog dialog = AbstractStudioWorkbench.getInstance().getDataTransformationDialog(this.getOwnerWindow(), this.getDataTransformationsTableModel(), selectedTransformation);
        if (dialog != null) {
            dialog.setVisible(true);
        }
    }
}

