/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.transformation;

import oracle.bpm.designer.argumentmapping.transformation.DataTransformationsTable;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.NotNull;

public class DataTransformationsDialog
extends OkCancelDialog {
    DataTransformationsTable inputsTable;
    DataTransformationsTable outputsTable;
    private DataAssociationSet inputDataAssociationSet;
    private DataAssociationSet outputDataAssociationSet;

    public DataTransformationsDialog(@NotNull UiWindow parent, DataAssociationSet inputDataAssociationSet, DataAssociationSet outputDataAssociationSet) {
        super(parent);
        this.inputDataAssociationSet = inputDataAssociationSet;
        this.outputDataAssociationSet = outputDataAssociationSet;
        this.init();
    }

    public void ok() {
        if (this.hasInputs()) {
            this.addAllDataTransformations(this.inputDataAssociationSet, this.inputsTable);
        }
        if (this.hasOutputs()) {
            this.addAllDataTransformations(this.outputDataAssociationSet, this.outputsTable);
        }
        this.close();
    }

    private void addAllDataTransformations(@NotNull DataAssociationSet dataAssociationSet, @NotNull DataTransformationsTable dataTransformationsTable) {
        dataAssociationSet.clearDataTransformations();
        for (DataTransformation dt : dataTransformationsTable.getDataTransformations()) {
            dataAssociationSet.addDataTransformation(dt);
        }
    }

    private boolean hasInputs() {
        return this.inputDataAssociationSet != null;
    }

    private boolean hasOutputs() {
        return this.outputDataAssociationSet != null;
    }

    private void init() {
        UiContainer parentContainer = this.getContentPane();
        TabbedPane tabbedPane = new TabbedPane(parentContainer);
        parentContainer.add((UiComponent)tabbedPane);
        if (this.hasInputs()) {
            this.inputsTable = new DataTransformationsTable(parentContainer, this.inputDataAssociationSet);
            tabbedPane.addTab(DesignerMsg.INPUTS, (UiComponent)this.inputsTable);
        }
        if (this.hasOutputs()) {
            this.outputsTable = new DataTransformationsTable(parentContainer, this.outputDataAssociationSet);
            tabbedPane.addTab(DesignerMsg.OUTPUTS, (UiComponent)this.outputsTable);
        }
        this.setTitle(DesignerMsg.TRANSFORMATIONS.getString());
        this.setSize(500, 300);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

