/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.model.ArgumentAccessType;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingModel;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObject;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroupListener;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.ui.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;

public class ArgumentMappingObjectGroup {
    private List<ArgumentMappingObject> children;
    private Sequence<DataDeclaration> declarations;
    private List<ArgumentMappingObjectGroupListener> groupListeners = new ArrayList<ArgumentMappingObjectGroupListener>();
    private String name;
    private ArgumentMappingModel parentModel;
    private ArgumentAccessType type;
    private DataDeclarationContainer variablesContext;
    private boolean visible;

    private ArgumentMappingObjectGroup(@NotNull ArgumentMappingModel parentModel, @NotNull Sequence<DataDeclaration> declarations, @NotNull String name, @NotNull ArgumentAccessType type, @NotNull DataDeclarationContainer variablesContext) {
        this.parentModel = parentModel;
        this.declarations = declarations;
        this.name = name;
        this.type = type;
        this.variablesContext = variablesContext;
    }

    public static ArgumentMappingObjectGroup create(@NotNull ArgumentMappingModel parentModel, @NotNull Sequence<DataDeclaration> declarations, @NotNull String name, @NotNull ArgumentAccessType type, @NotNull DataDeclarationContainer variablesContext) {
        return new ArgumentMappingObjectGroup(parentModel, declarations, name, type, variablesContext);
    }

    public ArgumentMappingObject createChild(@NotNull DataDeclaration dataDeclaration) {
        return ArgumentMappingObject.create(this, null, dataDeclaration);
    }

    public void addChild(@NotNull ArgumentMappingObject child) {
        this.children().add(child);
        this.fireChildAdded(child);
        this.fireGroupChanged();
    }

    public void removeChild(@NotNull ArgumentMappingObject child) {
        this.children().remove(child);
        this.fireGroupChanged();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.fireGroupChanged();
    }

    public ArgumentMappingObject findChild(Sequence<DataDeclaration> parts) {
        DataDeclaration dd;
        String name;
        ArgumentMappingObject argument = null;
        Sequence<ArgumentMappingObject> argumentMappingObjects = this.getChildren();
        Iterator<DataDeclaration> i$ = parts.iterator();
        while (i$.hasNext() && (argument = this.findArgumentMappingObject(argumentMappingObjects, name = (dd = i$.next()).getName())) != null) {
            argumentMappingObjects = argument.getChildren();
        }
        return argument;
    }

    public DataDeclarationContainer getVariablesContext() {
        return this.variablesContext;
    }

    public ExpressionMode getExpressionMode() {
        return this.parentModel.getExpressionMode();
    }

    public boolean showExpressionBuilder() {
        return this.getExpressionMode() == ExpressionMode.XPATH || this.getType() == ArgumentAccessType.INPUT || this.getType() == ArgumentAccessType.CUSTOM_OUTPUT;
    }

    public Sequence<ArgumentMappingObject> getChildren() {
        return CollectionUtils.asSequence(this.children());
    }

    public String getName() {
        return this.name;
    }

    public ArgumentAccessType getType() {
        return this.type;
    }

    public boolean isQuery() {
        return this.getType() == ArgumentAccessType.OUTPUT;
    }

    public void addListener(@NotNull ArgumentMappingObjectGroupListener listener) {
        this.groupListeners.add(listener);
    }

    public void removeListener(@NotNull ArgumentMappingObjectGroupListener listener) {
        this.groupListeners.remove(listener);
    }

    protected List<ArgumentMappingObject> loadChildren() {
        ArrayList<ArgumentMappingObject> result = new ArrayList<ArgumentMappingObject>();
        for (DataDeclaration child : this.declarations) {
            if (child.getType().isUnknown()) continue;
            result.add(ArgumentMappingObject.create(this, null, child));
        }
        return result;
    }

    private ArgumentMappingObject findArgumentMappingObject(@NotNull Sequence<ArgumentMappingObject> argumentMappingObjects, @NotNull String name) {
        ArgumentMappingObject result = null;
        for (ArgumentMappingObject child : argumentMappingObjects) {
            if (!child.getName().equals(name)) continue;
            result = child;
            break;
        }
        return result;
    }

    private List<ArgumentMappingObject> children() {
        if (this.children == null) {
            this.children = this.loadChildren();
        }
        return this.children;
    }

    private void fireChildAdded(ArgumentMappingObject child) {
        for (ArgumentMappingObjectGroupListener listener : this.groupListeners) {
            listener.childAdded(new ChangeEvent((Object)child));
        }
    }

    private void fireGroupChanged() {
        for (ArgumentMappingObjectGroupListener listener : this.groupListeners) {
            listener.groupChanged();
        }
    }
}

