/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.model;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroup;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectListener;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ArgumentMappingObject {
    protected DataDeclaration declarationObject;
    private List<ArgumentMappingObjectListener> argumentMappingObjectListeners = new ArrayList<ArgumentMappingObjectListener>();
    private List<ArgumentMappingObject> children;
    private DataDeclarationRenderer dataDeclarationRenderer;
    private ArgumentMappingObjectGroup group;
    private boolean isExpanded;
    private ArgumentMappingObject parent;
    private Expression relatedExpression;

    protected ArgumentMappingObject(@NotNull ArgumentMappingObjectGroup group, ArgumentMappingObject parent, @NotNull DataDeclaration declarationObject) {
        this.group = group;
        this.parent = parent;
        this.declarationObject = declarationObject;
    }

    public static ArgumentMappingObject create(@NotNull ArgumentMappingObjectGroup group, ArgumentMappingObject parent, @NotNull DataDeclaration declarationObject) {
        return new ArgumentMappingObject(group, parent, declarationObject);
    }

    public ArgumentMappingObjectGroup getGroup() {
        return this.group;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Sequence<ArgumentMappingObject> getPath() {
        ArrayList<ArgumentMappingObject> result = new ArrayList<ArgumentMappingObject>();
        if (this.getParent() != null) {
            for (ArgumentMappingObject element : this.getParent().getPath()) {
                result.add(element);
            }
        }
        result.add(this);
        return CollectionUtils.asSequence(result);
    }

    public Sequence<DataDeclaration> getDataDeclarationsPath() {
        ArrayList<DataDeclaration> dataDeclarationsPath = new ArrayList<DataDeclaration>();
        for (ArgumentMappingObject element : this.getPath()) {
            dataDeclarationsPath.add(element.getDeclarationObject());
        }
        return CollectionUtils.asSequence(dataDeclarationsPath);
    }

    public String getText() {
        return this.getDataDeclarationRenderer().getLabel(this.declarationObject);
    }

    public String getName() {
        return this.declarationObject.getName();
    }

    public Image getIcon() {
        return this.getDataDeclarationRenderer().getIcon(this.declarationObject);
    }

    public CatalogType getDataType() {
        return this.declarationObject.getType();
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void expand() {
        this.isExpanded = true;
        this.fireNodeExpanded();
    }

    public void collapse() {
        this.isExpanded = false;
        this.fireNodeCollapsed();
    }

    public void revalidate() {
        this.fireRevalidate();
    }

    public void addChild(@NotNull ArgumentMappingObject child) {
        this.children().add(child);
    }

    public void removeChild(ArgumentMappingObject child) {
        this.children().remove(child);
    }

    public Sequence<ArgumentMappingObject> getChildren() {
        return CollectionUtils.asSequence(this.children());
    }

    public ArgumentMappingObject getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return !this.children().isEmpty();
    }

    public void delete() {
        if (this.isRoot()) {
            this.getGroup().removeChild(this);
        } else {
            this.getParent().removeChild(this);
        }
        this.fireNodeDeleted();
    }

    public void expandParents() {
        for (ArgumentMappingObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
            parent.expand();
        }
    }

    public DataDeclaration getDeclarationObject() {
        return this.declarationObject;
    }

    public void setRelatedExpression(Expression relatedExpression) {
        this.relatedExpression = relatedExpression;
        this.fireRelatedExpressionChanged();
    }

    public Expression getRelatedExpression() {
        return this.relatedExpression;
    }

    public boolean isValid() {
        if (this.getRelatedExpression() == null) {
            return true;
        }
        DataDeclarationContainer context = this.getGroup().getVariablesContext();
        CatalogType dataType = !this.getGroup().isQuery() ? this.getDataType() : null;
        return ExpressionHelper.isExpressionValid((Expression)this.getRelatedExpression(), (DataDeclarationContainer)context, (CatalogType)dataType);
    }

    public void addNodeListener(ArgumentMappingObjectListener listener) {
        this.argumentMappingObjectListeners.add(listener);
    }

    public void removeNodeListener(ArgumentMappingObjectListener listener) {
        this.argumentMappingObjectListeners.remove(listener);
    }

    protected List<ArgumentMappingObject> loadChildren() {
        ArrayList<ArgumentMappingObject> result = new ArrayList<ArgumentMappingObject>();
        for (DataDeclaration child : this.declarationObject.getDeclarations()) {
            result.add(ArgumentMappingObject.create(this.group, this, child));
        }
        return result;
    }

    private List<ArgumentMappingObject> children() {
        if (this.children == null) {
            this.children = this.loadChildren();
        }
        return this.children;
    }

    private DataDeclarationRenderer getDataDeclarationRenderer() {
        if (this.dataDeclarationRenderer == null) {
            this.dataDeclarationRenderer = new DataDeclarationRenderer();
        }
        return this.dataDeclarationRenderer;
    }

    private void fireNodeExpanded() {
        for (ArgumentMappingObjectListener listener : this.argumentMappingObjectListeners) {
            listener.nodeExpanded();
        }
    }

    private void fireNodeCollapsed() {
        for (ArgumentMappingObjectListener listener : this.argumentMappingObjectListeners) {
            listener.nodeCollapsed();
        }
    }

    private void fireNodeDeleted() {
        for (ArgumentMappingObjectListener listener : this.argumentMappingObjectListeners) {
            listener.nodeDeleted();
        }
    }

    private void fireRelatedExpressionChanged() {
        for (ArgumentMappingObjectListener listener : this.argumentMappingObjectListeners) {
            listener.relatedExpressionChanged();
        }
    }

    private void fireRevalidate() {
        for (ArgumentMappingObjectListener listener : this.argumentMappingObjectListeners) {
            listener.revalidate();
        }
    }
}

