/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.model;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.model.ArgumentAccessType;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObject;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroup;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.DataDeclarationComposite;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.process.dataassociations.DataAssociationHelper;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class ArgumentMappingModel {
    private ArgumentMappingObjectGroup customsGroup;
    private boolean hasInvalidArgumentAssociations = false;
    private DataAssociationSet inputDataAssociationSet;
    private ArgumentMappingObjectGroup inputsGroup;
    private ExpressionMode mode;
    private DataAssociationSet outputDataAssociationSet;
    private ArgumentMappingObjectGroup outputsGroup;

    public ArgumentMappingModel(DataAssociationSet inputDataAssociationSet, DataAssociationSet outputDataAssociationSet, @NotNull ExpressionMode mode) {
        this.inputDataAssociationSet = inputDataAssociationSet;
        this.outputDataAssociationSet = outputDataAssociationSet;
        this.mode = mode;
        this.init();
    }

    public boolean hasInputs() {
        return this.inputDataAssociationSet != null;
    }

    public boolean hasOutputs() {
        return this.outputDataAssociationSet != null;
    }

    public ArgumentMappingObjectGroup getInputsGroup() {
        return this.inputsGroup;
    }

    public ArgumentMappingObjectGroup getOuputsGroup() {
        return this.outputsGroup;
    }

    public ArgumentMappingObjectGroup getCustomsGroup() {
        return this.customsGroup;
    }

    public boolean hasInvalidArgumentAssociations() {
        return this.hasInvalidArgumentAssociations;
    }

    public void setCustomAssignmentsEnabled(boolean customAssignmentsEnabled) {
        if (this.getCustomsGroup() != null) {
            this.getCustomsGroup().setVisible(customAssignmentsEnabled);
        }
    }

    public DataDeclarationContainer getVariablesProvider() {
        DataDeclarationContainer result = null;
        if (this.hasInputs()) {
            result = this.inputDataAssociationSet.getDataObjectsContainer();
        } else if (this.hasOutputs()) {
            result = this.outputDataAssociationSet.getDataObjectsContainer();
        }
        return result;
    }

    public DataDeclarationContainer getCustomOutputProvider() {
        DataDeclarationComposite result = null;
        if (this.hasOutputs()) {
            Project project = this.getVariablesProvider().getProject();
            ArrayList<DataDeclarationContainer> containers = new ArrayList<DataDeclarationContainer>();
            containers.add(this.outputDataAssociationSet.getArgumentsContainer());
            containers.add(this.getVariablesProvider());
            result = DataDeclarationComposite.createContainersComposite((Project)project, containers);
        }
        return result;
    }

    public ExpressionMode getExpressionMode() {
        return this.mode;
    }

    public void automapVariables() {
        if (this.hasInputs()) {
            this.automapVariables(this.inputsGroup, this.getVariablesProvider());
        }
        if (this.hasOutputs()) {
            this.automapVariables(this.outputsGroup, this.getVariablesProvider());
        }
    }

    public Msg validate() {
        Msg result;
        if (this.hasInputs() && (result = this.validateDataAssociationsGroup(this.inputsGroup)) != null) {
            return result;
        }
        if (this.hasOutputs()) {
            result = this.validateDataAssociationsGroup(this.outputsGroup);
            if (result != null) {
                return result;
            }
            result = this.validateDataAssociationsGroup(this.customsGroup);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public void revalidate() {
        if (this.hasInputs()) {
            this.revalidateDataAssociationsGroup(this.inputsGroup);
        }
        if (this.hasOutputs()) {
            this.revalidateDataAssociationsGroup(this.outputsGroup);
            this.revalidateDataAssociationsGroup(this.customsGroup);
        }
    }

    public Sequence<DataAssociation> getInputDataAssociations() {
        ArrayList<DataAssociation> dataAssociations = new ArrayList<DataAssociation>();
        if (this.hasInputs()) {
            for (ArgumentMappingObject child : this.inputsGroup.getChildren()) {
                this.addDataAssociationsRecursive(this.inputDataAssociationSet, dataAssociations, child);
            }
        }
        return CollectionUtils.asSequence(dataAssociations);
    }

    public Sequence<DataAssociation> getOutputDataAssociations() {
        ArrayList<DataAssociation> dataAssociations = new ArrayList<DataAssociation>();
        if (this.hasOutputs()) {
            for (ArgumentMappingObject child : this.outputsGroup.getChildren()) {
                this.addDataAssociationsRecursive(this.outputDataAssociationSet, dataAssociations, child);
            }
        }
        return CollectionUtils.asSequence(dataAssociations);
    }

    public Sequence<DataAssociation> getCustomDataAssociations() {
        ArrayList<DataAssociation> dataAssociations = new ArrayList<DataAssociation>();
        if (this.hasOutputs() && this.customsGroup.isVisible()) {
            for (ArgumentMappingObject child : this.customsGroup.getChildren()) {
                this.addDataAssociationsRecursive(this.outputDataAssociationSet, dataAssociations, child);
            }
        }
        return CollectionUtils.asSequence(dataAssociations);
    }

    private Sequence<ArgumentMappingObject> getSelectedArgumentMappingObject(@NotNull ArgumentMappingObjectGroup group) {
        ArrayList<ArgumentMappingObject> result = new ArrayList<ArgumentMappingObject>();
        for (ArgumentMappingObject child : group.getChildren()) {
            this.addArgumentMappingObjectRecursive(result, child);
        }
        return CollectionUtils.asSequence(result);
    }

    private void addArgumentMappingObjectRecursive(@NotNull List<ArgumentMappingObject> list, @NotNull ArgumentMappingObject object) {
        if (object.getRelatedExpression() != null) {
            list.add(object);
        }
        if (object.isExpanded()) {
            for (ArgumentMappingObject child : object.getChildren()) {
                this.addArgumentMappingObjectRecursive(list, child);
            }
        }
    }

    private Msg validateDataAssociationsGroup(@NotNull ArgumentMappingObjectGroup group) {
        for (ArgumentMappingObject child : this.getSelectedArgumentMappingObject(group)) {
            if (child.isExpanded() || child.isValid()) continue;
            return DesignerMsg.INVALID_DATA_ASSOCIATIONS;
        }
        return null;
    }

    private void revalidateDataAssociationsGroup(@NotNull ArgumentMappingObjectGroup group) {
        for (ArgumentMappingObject child : this.getSelectedArgumentMappingObject(group)) {
            child.revalidate();
        }
    }

    private void init() {
        if (this.hasInputs()) {
            this.inputsGroup = ArgumentMappingObjectGroup.create(this, this.inputDataAssociationSet.getArgumentsContainer().getDeclarations(), DesignerMsg.INPUTS.getString(), ArgumentAccessType.INPUT, this.getVariablesProvider());
            this.initDataAssociations(this.inputDataAssociationSet, this.inputsGroup);
        }
        if (this.hasOutputs()) {
            this.outputsGroup = ArgumentMappingObjectGroup.create(this, this.outputDataAssociationSet.getArgumentsContainer().getDeclarations(), DesignerMsg.OUTPUTS.getString(), ArgumentAccessType.OUTPUT, this.getVariablesProvider());
            this.initDataAssociations(this.outputDataAssociationSet, this.outputsGroup);
            this.customsGroup = ArgumentMappingObjectGroup.create(this, DataAssociationHelper.getCustomTargets((DataAssociationSet)this.outputDataAssociationSet), DesignerMsg.CUSTOM_ASSIGNMENTS.getString(), ArgumentAccessType.CUSTOM_OUTPUT, this.getCustomOutputProvider());
            this.initDataAssociations(this.outputDataAssociationSet, this.customsGroup);
        }
    }

    private void initDataAssociations(@NotNull DataAssociationSet dataAssociationSet, @NotNull ArgumentMappingObjectGroup argumentsGroup) {
        ArgumentAccessType type = argumentsGroup.getType();
        for (DataAssociation da : dataAssociationSet.getDataAssociations()) {
            DataAssociationItem argumentDataAssociationItem;
            if (da.isCustom() != (type == ArgumentAccessType.CUSTOM_OUTPUT)) continue;
            DataAssociationItem dataAssociationItem = argumentDataAssociationItem = type == ArgumentAccessType.OUTPUT ? da.getSource() : da.getTarget();
            assert (argumentDataAssociationItem.isQuery()) : "Query expression expected";
            try {
                Sequence parts = ExpressionHelper.getDeclarationsPath((Expression)argumentDataAssociationItem.getExpression(), (DataDeclarationContainer)argumentDataAssociationItem.getContext());
                if (parts != null) {
                    ArgumentMappingObject argument = argumentsGroup.findChild(parts);
                    if (argument != null) {
                        argument.expandParents();
                        DataAssociationItem relatedDataAssociationItem = type.equals((Object)ArgumentAccessType.OUTPUT) ? da.getTarget() : da.getSource();
                        argument.setRelatedExpression(relatedDataAssociationItem.getExpression());
                        continue;
                    }
                    this.hasInvalidArgumentAssociations = true;
                    continue;
                }
                this.hasInvalidArgumentAssociations = true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private void automapVariables(@NotNull ArgumentMappingObjectGroup argumentsGroup, @NotNull DataDeclarationContainer variablesProvider) {
        for (ArgumentMappingObject argument : argumentsGroup.getChildren()) {
            for (DataDeclaration variable : variablesProvider.getDeclarations()) {
                if (argument.getRelatedExpression() != null || !variable.getName().equals(argument.getName()) || !variable.getType().isAssignableFrom(argument.getDataType())) continue;
                ArrayList<DataDeclaration> list = new ArrayList<DataDeclaration>();
                list.add(variable);
                CatalogType resultType = !argument.getGroup().isQuery() ? argument.getDataType() : null;
                Expression expression = ExpressionHelper.createExpressionFromParts((ExpressionMode)this.mode, CollectionUtils.asSequence(list), (DataDeclarationContainer)variablesProvider, (CatalogType)resultType, null);
                argument.setRelatedExpression(expression);
            }
        }
    }

    private void addDataAssociationsRecursive(@NotNull DataAssociationSet dataAssociationSet, @NotNull List<DataAssociation> dataAssociations, @NotNull ArgumentMappingObject argument) {
        if (!argument.isExpanded() && argument.getRelatedExpression() != null) {
            DataAssociationItem source = null;
            DataAssociationItem target = null;
            ArgumentAccessType type = argument.getGroup().getType();
            boolean isCustom = false;
            if (type == ArgumentAccessType.INPUT) {
                source = this.createDataAssociationItemFromExpression(dataAssociationSet, DataAssociationItemEndpoint.SOURCE, argument.getRelatedExpression());
                target = this.createDataAssociationItemFromParts(dataAssociationSet, DataAssociationItemEndpoint.TARGET, argument.getDataDeclarationsPath(), null);
            } else if (type == ArgumentAccessType.OUTPUT) {
                target = this.createDataAssociationItemFromExpression(dataAssociationSet, DataAssociationItemEndpoint.TARGET, argument.getRelatedExpression());
                CatalogType targetType = ExpressionHelper.getExpressionType((Expression)argument.getRelatedExpression(), (DataDeclarationContainer)dataAssociationSet.getContextProvider(DataAssociationItemEndpoint.TARGET).getDataDeclarationContainer(), null);
                source = this.createDataAssociationItemFromParts(dataAssociationSet, DataAssociationItemEndpoint.SOURCE, argument.getDataDeclarationsPath(), targetType);
            } else if (type == ArgumentAccessType.CUSTOM_OUTPUT) {
                source = this.createDataAssociationItemFromExpression(dataAssociationSet, DataAssociationItemEndpoint.CUSTOM_SOURCE, argument.getRelatedExpression());
                target = this.createDataAssociationItemFromParts(dataAssociationSet, DataAssociationItemEndpoint.CUSTOM_TARGET, argument.getDataDeclarationsPath(), null);
                isCustom = true;
            }
            if (source != null && target != null) {
                DataAssociation da = dataAssociationSet.createDataAssociation(source, target);
                da.setIsCustom(isCustom);
                dataAssociations.add(da);
            }
        }
        if (argument.isExpanded()) {
            for (ArgumentMappingObject child : argument.getChildren()) {
                this.addDataAssociationsRecursive(dataAssociationSet, dataAssociations, child);
            }
        }
    }

    private DataAssociationItem createDataAssociationItemFromExpression(@NotNull DataAssociationSet dataAssociationSet, @NotNull DataAssociationItemEndpoint endpoint, @NotNull Expression expression) {
        return dataAssociationSet.createDataAssociationItem(endpoint, expression);
    }

    private DataAssociationItem createDataAssociationItemFromParts(@NotNull DataAssociationSet dataAssociationSet, @NotNull DataAssociationItemEndpoint endpoint, @NotNull Sequence<DataDeclaration> parts, CatalogType resultType) {
        ExpressionMode mode = dataAssociationSet.getExpressionMode();
        DataDeclarationContainer context = dataAssociationSet.getContextProvider(endpoint).getDataDeclarationContainer();
        Expression expression = ExpressionHelper.createExpressionFromParts((ExpressionMode)mode, parts, (DataDeclarationContainer)context, (CatalogType)resultType, null);
        return dataAssociationSet.createDataAssociationItem(endpoint, expression);
    }
}

