/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.expressionfield;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionFieldListener;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class TextExpressionField
extends Panel
implements ExpressionField {
    private DataDeclarationContainer context;
    private Expression expression;
    private List<ExpressionFieldListener> listeners = new ArrayList<ExpressionFieldListener>();
    private TextField textField;

    public TextExpressionField(@NotNull UiContainer parent, @NotNull DataDeclarationContainer context) {
        super(parent);
        this.context = context;
        this.init();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public void setResultType(CatalogType resultType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CatalogType getResultType() {
        return CatalogType.Default.getString();
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.TEXT)) : "Invalid expression mode for Text field";
        if (this.expression == null && expression == null || this.expression != null && this.expression.equals(expression)) {
            return;
        }
        this.expression = expression;
        this.revalidateExpression();
        this.fireExpressionChanged();
    }

    @Override
    public void revalidateExpression() {
        this.setTextFromExpression();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void addListener(ExpressionFieldListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExpressionFieldListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fillx"));
        this.setBackground(this.getParent().getBackground());
        this.textField = this.createLiteralTextField((UiContainer)this);
        this.add((UiComponent)this.textField, "growx");
        this.revalidateExpression();
    }

    private void setExpressionFromText() {
        Expression expression = null;
        if (!Str.isEmpty(this.textField.getText())) {
            expression = ExpressionHelper.createTextExpression((String)this.textField.getText());
        }
        this.setExpression(expression);
    }

    private TextField createLiteralTextField(@NotNull UiContainer container) {
        TextField newtextField = new TextField(container);
        newtextField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TextExpressionField.this.setExpressionFromText();
            }
        });
        return newtextField;
    }

    private void setTextFromExpression() {
        String text = this.expression != null ? ExpressionHelper.getText((Expression)this.expression, (DataDeclarationContainer)this.context, null) : "";
        this.textField.setText(text);
    }

    private void fireExpressionChanged() {
        for (ExpressionFieldListener listener : this.listeners) {
            listener.expressionChanged();
        }
    }
}

