/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.expressionfield;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ExpressionBuilder;
import oracle.bpm.designer.ExpressionBuilderService;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionFieldListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class SimpleExpressionField
extends Panel
implements ExpressionField {
    private DataDeclarationContainer context;
    private Expression expression;
    private Button expressionBuilderIcon;
    private List<ExpressionFieldListener> listeners = new ArrayList<ExpressionFieldListener>();
    private ExpressionField.ExpressionFieldMode mode;
    private CatalogType resultType;
    private TextField textField;

    public SimpleExpressionField(@NotNull UiContainer parent, @NotNull ExpressionField.ExpressionFieldMode mode, @NotNull DataDeclarationContainer context, CatalogType resultType, boolean showExpressionBuilder) {
        super(parent);
        this.mode = mode;
        this.context = context;
        this.init(resultType, showExpressionBuilder);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        if (this.expressionBuilderIcon != null) {
            this.expressionBuilderIcon.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public void setResultType(CatalogType resultType) {
        Msg tooltip = resultType != null ? Msg.QUOTE(resultType.getName()) : null;
        this.textField.setToolTipText(tooltip);
        this.resultType = resultType;
    }

    @Override
    public CatalogType getResultType() {
        return this.resultType;
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.SIMPLE)) : "Invalid expression mode for Simple field";
        if (this.expression == null && expression == null || this.expression != null && this.expression.equals(expression)) {
            return;
        }
        this.expression = expression;
        this.revalidateExpression();
        this.fireExpressionChanged();
    }

    @Override
    public void revalidateExpression() {
        this.setTextFromExpression();
        this.setColorFromExpression();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void addListener(ExpressionFieldListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExpressionFieldListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isValid() {
        CatalogType dataType = this.mode != ExpressionField.ExpressionFieldMode.QUERY ? this.getResultType() : null;
        return this.expression == null || ExpressionHelper.isExpressionValid((Expression)this.expression, (DataDeclarationContainer)this.context, (CatalogType)dataType);
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void init(CatalogType resultType, boolean showExpressionBuilder) {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fillx"));
        this.setBackground(this.getParent().getBackground());
        this.textField = this.createArgumentTextField((UiContainer)this);
        this.add((UiComponent)this.textField, "growx");
        this.setResultType(resultType);
        if (showExpressionBuilder) {
            this.expressionBuilderIcon = this.createExpressionBuilderButton((UiContainer)this);
            this.add((UiComponent)this.expressionBuilderIcon, "gapx 5");
        }
        this.revalidateExpression();
    }

    private void setExpressionFromText() {
        Expression expression = null;
        if (!Str.isEmpty(this.textField.getText())) {
            CatalogType resultType = !this.isLValue() ? this.getResultType() : null;
            expression = ExpressionHelper.createSimpleExpression((String)this.textField.getText(), (DataDeclarationContainer)this.context, (CatalogType)resultType, null);
        }
        this.setExpression(expression);
    }

    private boolean isLValue() {
        return this.mode == ExpressionField.ExpressionFieldMode.QUERY;
    }

    private TextField createArgumentTextField(@NotNull UiContainer container) {
        final TextField newtextField = new TextField(container);
        newtextField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SimpleExpressionField.this.setExpressionFromText();
            }
        });
        new DropTargetHandler((UiComponent)newtextField, DndAction.COPY_OR_MOVE){

            public void drop(Object data, Transfer type, Point point, DndAction dndAction) {
                if (type == LocalObjectTransfer.getInstance(Sequence.class)) {
                    Sequence dataDeclarationsPath = (Sequence)Cast.force(data);
                    CatalogType resultType = !SimpleExpressionField.this.isLValue() ? SimpleExpressionField.this.getResultType() : null;
                    Expression expression = ExpressionHelper.createExpressionFromParts((ExpressionMode)ExpressionMode.SIMPLE, (Sequence)dataDeclarationsPath, (DataDeclarationContainer)SimpleExpressionField.this.context, (CatalogType)resultType, null);
                    SimpleExpressionField.this.setExpression(expression);
                }
            }

            public Transfer[] getTransfers() {
                return new Transfer[]{LocalObjectTransfer.getInstance(Sequence.class)};
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                if (newtextField.isEnabled() && transfer.equals(LocalObjectTransfer.getInstance(Sequence.class))) {
                    Sequence dataDeclarationsPath = (Sequence)Cast.force(data);
                    CatalogType leafType = this.getLeaf(dataDeclarationsPath).getType();
                    boolean isLeafReadOnly = this.getLeaf(dataDeclarationsPath).isReadOnly();
                    return !(SimpleExpressionField.this.resultType != null && !SimpleExpressionField.this.resultType.isAssignableFrom(leafType) || SimpleExpressionField.this.mode == ExpressionField.ExpressionFieldMode.QUERY && isLeafReadOnly);
                }
                return false;
            }

            private DataDeclaration getLeaf(Sequence<DataDeclaration> dataDeclarationsPath) {
                DataDeclaration result = null;
                Iterator<DataDeclaration> i$ = dataDeclarationsPath.iterator();
                while (i$.hasNext()) {
                    DataDeclaration part;
                    result = part = i$.next();
                }
                return result;
            }
        };
        return newtextField;
    }

    private void setColorFromExpression() {
        this.textField.setForeground(this.isValid() ? Color.BLACK : Color.RED);
    }

    private void setTextFromExpression() {
        String text = this.expression != null ? ExpressionHelper.getText((Expression)this.expression, (DataDeclarationContainer)this.context, (CatalogType)this.resultType) : "";
        this.textField.setText(text);
    }

    private Button createExpressionBuilderButton(UiContainer container) {
        Button button = Button.createIconic((UiContainer)container, (Msg)DesignerMsg.EXPRESSION_BUILDER);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionBuilder expressionBuilder;
                SimpleExpressionField.this.setExpressionFromText();
                ExpressionBuilderService service = AbstractStudioWorkbench.getInstance().getExpressionBuilderService();
                ExpressionBuilder expressionBuilder2 = expressionBuilder = service != null ? service.getExpressionBuilder(ExpressionMode.SIMPLE, SimpleExpressionField.this.context, SimpleExpressionField.this.resultType, SimpleExpressionField.this.expression, SimpleExpressionField.this.mode) : null;
                if (expressionBuilder != null && expressionBuilder.showDialog()) {
                    SimpleExpressionField.this.setExpression(expressionBuilder.getExpression());
                }
            }
        });
        return button;
    }

    private void fireExpressionChanged() {
        for (ExpressionFieldListener listener : this.listeners) {
            listener.expressionChanged();
        }
    }
}

