/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.expressionfield;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.CodeEditorService;
import oracle.bpm.designer.ExpressionBuilder;
import oracle.bpm.designer.ExpressionBuilderService;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionFieldListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class SimpleExpressionEditorField
extends Panel
implements ExpressionField {
    private CodeEditor codeEditor;
    private DataDeclarationContainer context;
    private Expression expression;
    private Button expressionBuilderIcon;
    private List<ExpressionFieldListener> listeners = new ArrayList<ExpressionFieldListener>();
    private ExpressionField.ExpressionFieldMode mode;
    private CatalogType resultType;
    private UiComponent textComponent;

    public SimpleExpressionEditorField(@NotNull UiContainer parent, @NotNull ExpressionField.ExpressionFieldMode mode, @NotNull DataDeclarationContainer context, CatalogType resultType, boolean showExpressionBuilder) {
        super(parent);
        this.mode = mode;
        this.context = context;
        this.resultType = resultType;
        this.init(showExpressionBuilder);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textComponent.setEnabled(enabled);
        if (this.expressionBuilderIcon != null) {
            this.expressionBuilderIcon.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.textComponent.isEnabled();
    }

    @Override
    public void setResultType(CatalogType resultType) {
        this.resultType = resultType;
    }

    @Override
    public CatalogType getResultType() {
        return this.resultType;
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.SIMPLE)) : "Invalid expression mode for Simple field";
        if (this.expression == null && expression == null || this.expression != null && this.expression.equals(expression)) {
            return;
        }
        this.expression = expression;
        this.setText();
        this.fireExpressionChanged();
    }

    @Override
    public void revalidateExpression() {
        this.setText();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void addListener(ExpressionFieldListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExpressionFieldListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isValid() {
        CatalogType dataType = !this.isLValue() ? this.getResultType() : null;
        return this.expression == null || ExpressionHelper.isExpressionValid((Expression)this.expression, (DataDeclarationContainer)this.context, (CatalogType)dataType);
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void init(boolean showExpressionBuilder) {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fillx"));
        this.setBackground(this.getParent().getBackground());
        this.initCodeEditor();
        this.textComponent = this.createExpressionField((UiContainer)this);
        this.add(this.textComponent, "growx, height 140!");
        if (showExpressionBuilder) {
            this.expressionBuilderIcon = this.createExpressionBuilderButton((UiContainer)this);
            this.add((UiComponent)this.expressionBuilderIcon, "aligny top, gapx 5");
        }
        this.setText();
    }

    private void initCodeEditor() {
        CodeEditorService service = AbstractStudioWorkbench.getInstance().getCodeEditorService();
        this.codeEditor = service.getFusionCodeEditor(this.context, this.resultType);
        this.codeEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SimpleExpressionEditorField.this.setExpressionFromText();
            }
        });
    }

    private void setExpressionFromText() {
        Expression expression = null;
        if (!Str.isEmpty(this.codeEditor.getText())) {
            CatalogType dataType = !this.isLValue() ? this.getResultType() : null;
            expression = ExpressionHelper.createSimpleExpression((String)this.codeEditor.getText(), (DataDeclarationContainer)this.context, (CatalogType)dataType, null);
        }
        this.setExpression(expression);
    }

    private boolean isLValue() {
        return this.mode == ExpressionField.ExpressionFieldMode.QUERY;
    }

    private UiComponent createExpressionField(@NotNull UiContainer container) {
        return this.codeEditor.getView();
    }

    private void setText() {
        String text = this.expression != null ? ExpressionHelper.getText((Expression)this.expression, (DataDeclarationContainer)this.context, (CatalogType)this.resultType) : "";
        this.codeEditor.setText(text);
    }

    private Button createExpressionBuilderButton(UiContainer container) {
        Button button = Button.createIconic((UiContainer)container, (Msg)DesignerMsg.EXPRESSION_BUILDER);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionBuilder expressionBuilder;
                SimpleExpressionEditorField.this.setExpressionFromText();
                ExpressionBuilderService service = AbstractStudioWorkbench.getInstance().getExpressionBuilderService();
                ExpressionBuilder expressionBuilder2 = expressionBuilder = service != null ? service.getExpressionBuilder(ExpressionMode.SIMPLE, SimpleExpressionEditorField.this.context, SimpleExpressionEditorField.this.resultType, SimpleExpressionEditorField.this.expression, SimpleExpressionEditorField.this.mode) : null;
                if (expressionBuilder != null && expressionBuilder.showDialog()) {
                    SimpleExpressionEditorField.this.setExpression(expressionBuilder.getExpression());
                }
            }
        });
        return button;
    }

    private void fireExpressionChanged() {
        for (ExpressionFieldListener listener : this.listeners) {
            listener.expressionChanged();
        }
    }
}

