/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.expressionfield;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionFieldListener;
import oracle.bpm.designer.argumentmapping.expressionfield.SimpleExpressionEditorField;
import oracle.bpm.designer.argumentmapping.expressionfield.SimpleExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.TextExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.XPathExpressionField;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public abstract class ExpressionPanel
extends Panel
implements ExpressionField {
    protected DataDeclarationContainer context;
    protected ExpressionField delegate;
    protected ExpressionMode expressionMode = ExpressionMode.SIMPLE;
    private List<ExpressionFieldListener> listeners = new ArrayList<ExpressionFieldListener>();
    private CatalogType resultType;

    private ExpressionPanel(@NotNull UiContainer parent, @NotNull DataDeclarationContainer context, CatalogType resultType) {
        super(parent);
        this.context = context;
        this.resultType = resultType;
        this.expressionMode = this.getAvailableModes().get(0);
        this.init();
    }

    public static ExpressionPanel createWithRadioSelector(@NotNull UiContainer parent, @NotNull DataDeclarationContainer context, CatalogType resultType) {
        return new ExpressionRadioPanel(parent, context, resultType);
    }

    public static ExpressionPanel createWithComboSelector(@NotNull UiContainer parent, @NotNull DataDeclarationContainer context, CatalogType resultType) {
        return new ExpressionComboPanel(parent, context, resultType);
    }

    public ExpressionMode getExpressionMode() {
        return this.expressionMode;
    }

    @Override
    public void setResultType(CatalogType resultType) {
        this.resultType = resultType;
        if (this.getExpressionField() != null) {
            this.getExpressionField().setResultType(resultType);
        }
    }

    @Override
    public CatalogType getResultType() {
        return this.resultType;
    }

    @Override
    public void setExpression(Expression expression) {
        if (this.getExpression() == null && expression == null || this.getExpression() != null && this.getExpression().equals(expression)) {
            return;
        }
        if (expression != null && !expression.getMode().equals(this.expressionMode)) {
            this.setExpressionMode(expression.getMode());
        }
        this.delegate.setExpression(expression);
    }

    @Override
    public void revalidateExpression() {
        this.delegate.revalidateExpression();
    }

    @Override
    public Expression getExpression() {
        return this.delegate.getExpression();
    }

    @Override
    public void addListener(ExpressionFieldListener listener) {
        this.listeners.add(listener);
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(ExpressionFieldListener listener) {
        this.listeners.remove(listener);
        this.delegate.removeListener(listener);
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.delegate.isValid();
    }

    @Override
    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    protected void setExpressionMode(ExpressionMode expressionMode) {
        int answer;
        if (expressionMode.equals(this.expressionMode)) {
            return;
        }
        Expression convertedExpression = this.convertExpression(expressionMode);
        if (this.getExpression() != null && convertedExpression == null && (answer = MessageDialog.showQuestion((Msg)DesignerMsg.EXPRESSION, (Msg)DesignerMsg.CONFIRM_EXPRESSION_CONVERSION, (int)6)) == 4) {
            this.changeMode(this.getExpression());
            return;
        }
        this.expressionMode = expressionMode;
        this.changeMode(convertedExpression);
    }

    protected List<ExpressionMode> getAvailableModes() {
        ArrayList<ExpressionMode> result = new ArrayList<ExpressionMode>();
        if (CatalogType.Default.getString().equals(this.getResultType())) {
            result.add(ExpressionMode.TEXT);
        }
        result.add(ExpressionMode.SIMPLE);
        result.add(ExpressionMode.XPATH);
        return result;
    }

    protected void rebuildDelegate() {
        if (this.delegate != null) {
            this.delegate.getUiComponent().getParent().remove(this.delegate.getUiComponent());
        }
        this.delegate = this.getExpressionField();
        this.add(this.delegate.getUiComponent(), "growx, wrap");
        for (ExpressionFieldListener listener : this.listeners) {
            this.delegate.addListener(listener);
        }
        this.revalidate();
    }

    abstract void addSelectorPanel(@NotNull UiContainer var1);

    abstract void setSelectorMode(ExpressionMode var1);

    abstract ExpressionField getExpressionField();

    private void changeMode(Expression convertedExpression) {
        this.setSelectorMode(this.expressionMode);
        this.rebuildDelegate();
        this.delegate.setExpression(convertedExpression);
    }

    private Expression convertExpression(ExpressionMode newExpressionMode) {
        Expression result = null;
        if (this.getExpression() != null && !(this.getExpression() instanceof InvalidExpression) && (result = ExpressionHelper.convertExpression((XPathExpression)((XPathExpression)this.getExpression()), (DataDeclarationContainer)this.context, (CatalogType)this.resultType, (ExpressionMode)newExpressionMode)) != null && result instanceof InvalidExpression) {
            result = null;
        }
        return result;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fillx"));
        this.setBackground(this.getParent().getBackground());
        this.addSelectorPanel((UiContainer)this);
        this.changeMode(null);
    }

    private static class ExpressionRadioPanel
    extends ExpressionPanel {
        private Map<ExpressionMode, RadioButton<ExpressionMode>> modeSelectionButtons;
        private ButtonGroup modeSelectionGroup;

        public ExpressionRadioPanel(@NotNull UiContainer parent, @NotNull DataDeclarationContainer context, CatalogType resultType) {
            super(parent, context, resultType);
        }

        @Override
        public void setEnabled(boolean enabled) {
            for (RadioButton<ExpressionMode> button : this.modeSelectionButtons.values()) {
                button.setEnabled(enabled);
            }
            this.delegate.setEnabled(enabled);
        }

        @Override
        protected ExpressionField getExpressionField() {
            Panel result = null;
            if (this.getExpressionMode().equals(ExpressionMode.SIMPLE)) {
                result = new SimpleExpressionEditorField((UiContainer)this, ExpressionField.ExpressionFieldMode.EXPRESSION, this.context, this.getResultType(), true);
            } else if (this.getExpressionMode().equals(ExpressionMode.XPATH)) {
                result = new XPathExpressionField((UiContainer)this, this.context);
            } else if (this.getExpressionMode().equals(ExpressionMode.TEXT)) {
                result = new TextExpressionField((UiContainer)this, this.context);
            }
            return result;
        }

        @Override
        void addSelectorPanel(@NotNull UiContainer container) {
            Panel modeSelectorPanel = new Panel(container);
            modeSelectorPanel.setLayout((Layout)new MigLayout("ins 0, gap 0"));
            this.modeSelectionGroup = new ButtonGroup();
            this.modeSelectionButtons = new HashMap<ExpressionMode, RadioButton<ExpressionMode>>();
            for (ExpressionMode mode : this.getAvailableModes()) {
                this.addRadio((UiContainer)modeSelectorPanel, mode);
            }
            container.add((UiComponent)modeSelectorPanel, (Object)"gapbottom 5, wrap");
        }

        @Override
        void setSelectorMode(ExpressionMode mode) {
            RadioButton<ExpressionMode> radio = this.modeSelectionButtons.get(mode);
            if (radio != null) {
                this.modeSelectionGroup.setSelected(radio, true);
            }
        }

        private void addRadio(@NotNull UiContainer container, @NotNull ExpressionMode expressionMode) {
            final RadioButton modeRadioButton = new RadioButton(container, expressionMode.getString());
            modeRadioButton.setItem((Object)expressionMode);
            this.modeSelectionButtons.put(expressionMode, (RadioButton<ExpressionMode>)modeRadioButton);
            this.modeSelectionGroup.add((AbstractButton)modeRadioButton);
            container.add((UiComponent)modeRadioButton, (Object)"gapright 5");
            modeRadioButton.addModificationListener(new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    if (modeRadioButton.isSelected()) {
                        ExpressionRadioPanel.this.setExpressionMode((ExpressionMode)modeRadioButton.getItem());
                    }
                }
            });
        }
    }

    private static class ExpressionComboPanel
    extends ExpressionPanel {
        private ComboBox<ExpressionMode> comboSelector;

        public ExpressionComboPanel(@NotNull UiContainer parent, @NotNull DataDeclarationContainer context, CatalogType resultType) {
            super(parent, context, resultType);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.comboSelector.setEnabled(enabled);
            this.delegate.setEnabled(enabled);
        }

        @Override
        protected ExpressionField getExpressionField() {
            Panel result = null;
            if (this.getExpressionMode().equals(ExpressionMode.SIMPLE)) {
                result = new SimpleExpressionField((UiContainer)this, ExpressionField.ExpressionFieldMode.EXPRESSION, this.context, this.getResultType(), true);
            } else if (this.getExpressionMode().equals(ExpressionMode.XPATH)) {
                result = new XPathExpressionField((UiContainer)this, this.context);
            } else if (this.getExpressionMode().equals(ExpressionMode.TEXT)) {
                result = new TextExpressionField((UiContainer)this, this.context);
            }
            return result;
        }

        @Override
        void addSelectorPanel(@NotNull UiContainer container) {
            this.comboSelector = UiFactory.createComboBox((UiContainer)container);
            for (ExpressionMode mode : this.getAvailableModes()) {
                this.comboSelector.addItem((Object)mode);
            }
            this.comboSelector.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        ExpressionComboPanel.this.setExpressionMode((ExpressionMode)ExpressionComboPanel.this.comboSelector.getSelectedItem());
                    }
                }
            });
            container.add(this.comboSelector, (Object)"gapright 5");
        }

        @Override
        void setSelectorMode(ExpressionMode mode) {
            this.comboSelector.setSelectedItem((Object)mode);
        }
    }
}

