/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.datadeclarations;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsSortOrder;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationsTree
extends Tree {
    private boolean canExpandDeclarations;
    private ExpressionMode expressionMode = ExpressionMode.SIMPLE;
    private boolean isPlainViewTree = false;
    private boolean showDataType = false;
    private DataDeclarationsSortOrder sortOrder = DataDeclarationsSortOrder.ASCENDING;
    private Map<String, URI> usedNamespaces = new HashMap<String, URI>();

    public DataDeclarationsTree(UiContainer parent, boolean canExpandDeclarations) {
        super(parent, false);
        this.canExpandDeclarations = canExpandDeclarations;
        this.initUI();
    }

    public ExpressionMode getExpressionMode() {
        return this.expressionMode;
    }

    public void setExpressionMode(ExpressionMode expressionMode) {
        this.expressionMode = expressionMode;
    }

    public boolean getShowDataType() {
        return this.showDataType;
    }

    public boolean isPlainViewTree() {
        return this.isPlainViewTree;
    }

    public void setIsPlainViewTree(boolean isPlainViewTree) {
        this.isPlainViewTree = isPlainViewTree;
        this.reloadTree();
    }

    public boolean canExpandDeclarations() {
        return this.canExpandDeclarations;
    }

    public void setShowDataType(boolean showDataType) {
        this.showDataType = showDataType;
        this.reloadTree();
    }

    public DataDeclarationsSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(DataDeclarationsSortOrder sortOrder) {
        this.sortOrder = sortOrder;
        this.reloadTree();
    }

    public void setRoot(TreeNode node) {
        super.setRoot(node);
        this.expandFirstLevelNodes();
    }

    public void setUsedNamespaces(Map<String, URI> usedNamespaces) {
        this.usedNamespaces = usedNamespaces;
    }

    public Map<String, URI> getUsedNamespaces() {
        return this.usedNamespaces;
    }

    public void appendUsedNamespaces(@NotNull Map<String, URI> newNamespaces) {
        for (String id : newNamespaces.keySet()) {
            if (this.usedNamespaces.containsKey(id)) continue;
            this.usedNamespaces.put(id, newNamespaces.get(id));
        }
    }

    private void initUI() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setSelectionMode(TreeSelectionMode.SINGLE_TREE_SELECTION);
        new DragSourceHandler((UiComponent)this, DndAction.COPY_OR_MOVE){
            private DragItem dragItem;
            {
                this.dragItem = null;
            }

            public Transfer[] getTransfers() {
                DragItem nodeDragItem;
                TreeNode node = DataDeclarationsTree.this.getSelectedTreeNode();
                DragItem dragItem = nodeDragItem = node instanceof DragItem ? (DragItem)node : null;
                if (nodeDragItem != null) {
                    this.dragItem = nodeDragItem;
                }
                return this.dragItem != null ? this.dragItem.getTransfers() : Transfer.NONE;
            }

            public Object getObject(Transfer transfer) {
                return this.dragItem.getObjectAs(transfer);
            }
        };
    }

    private void expandFirstLevelNodes() {
        if (!this.isPlainViewTree) {
            for (TreeNode node : this.getRoot().getChildren()) {
                node.expand();
            }
        }
    }

    private void reloadTree() {
        TreeNode root = this.getRoot();
        if (root != null) {
            root.unload();
            root.reload();
            this.expandFirstLevelNodes();
        }
    }
}

