/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.datadeclarations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import oracle.bpm.designer.AbstractTreeNode;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationContainerTreeNode;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsPanelModelListener;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsSortOrder;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsTree;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.DataDeclarationComposite;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.TreeModelAdapter;
import oracle.bpm.ui.event.TreeModelEvent;
import oracle.bpm.ui.event.TreeModelListener;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationsPanel
extends Panel {
    private boolean canExpandDeclarations = false;
    private DataDeclarationContainer dataDeclarationsContainer;
    private ArrayList<DataDeclarationsPanelModelListener> modelListeners = new ArrayList();
    private DataDeclarationsTree tree;

    public DataDeclarationsPanel(UiContainer parent, @NotNull DataDeclarationContainer dataDeclarationsContainer, @NotNull DataDeclarationsPanelMode mode, boolean canExpandDeclarations) {
        super(parent);
        this.dataDeclarationsContainer = dataDeclarationsContainer;
        this.canExpandDeclarations = canExpandDeclarations;
        DataDeclarationsPanelMode fixedMode = dataDeclarationsContainer instanceof DataDeclarationComposite ? DataDeclarationsPanelMode.PLAIN_ONLY : mode;
        this.init(fixedMode);
    }

    public void setExpressionMode(ExpressionMode expressionMode) {
        this.tree.setExpressionMode(expressionMode);
    }

    public void setSortOrder(@NotNull DataDeclarationsSortOrder sortOrder) {
        this.tree.setSortOrder(sortOrder);
    }

    public boolean showDataType() {
        return this.tree.getShowDataType();
    }

    public void setShowDataType(boolean showDataType) {
        this.tree.setShowDataType(showDataType);
    }

    public void addSelectionListener(@NotNull TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void removeSelectionListener(@NotNull TreeSelectionListener listener) {
        this.tree.removeTreeSelectionListener(listener);
    }

    public void addModelListener(@NotNull DataDeclarationsPanelModelListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeModelListener(@NotNull DataDeclarationsPanelModelListener listener) {
        this.modelListeners.remove(listener);
    }

    public TreeNode getSelectedNode() {
        return this.tree.getSelectedTreeNode();
    }

    public void setUsedNamespaces(Map<String, URI> usedNamespaces) {
        this.tree.setUsedNamespaces(usedNamespaces);
    }

    public Map<String, URI> getUsedNamespaces() {
        return this.tree.getUsedNamespaces();
    }

    private void init(@NotNull DataDeclarationsPanelMode mode) {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.add((UiComponent)this.createToolBar((UiContainer)this, mode), "growx, wrap");
        this.tree = new DataDeclarationsTree((UiContainer)this, this.canExpandDeclarations);
        this.resetTreeRoot(mode.equals((Object)DataDeclarationsPanelMode.PLAIN_ONLY));
        this.add((UiComponent)this.tree, "grow");
        this.tree.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent e) {
                DataDeclarationsPanel.this.fireModelChanged();
            }
        });
    }

    private ToolBar createToolBar(@NotNull UiContainer container, @NotNull DataDeclarationsPanelMode mode) {
        ToolBar result = new ToolBar(container, ToolBar.Orientation.HORIZONTAL);
        ToolBarItem sortAscending = result.addRadioButton(new BaseAction(DesignerMsg.SORT_ASCENDING){

            public void actionPerformed(ActionEvent event) {
                DataDeclarationsPanel.this.setSortOrder(DataDeclarationsSortOrder.ASCENDING);
            }
        });
        sortAscending.setSelected(true);
        ToolBarItem sortDescending = result.addRadioButton(new BaseAction(DesignerMsg.SORT_DESCENDING){

            public void actionPerformed(ActionEvent event) {
                DataDeclarationsPanel.this.setSortOrder(DataDeclarationsSortOrder.DESCENDING);
            }
        });
        sortDescending.setSelected(false);
        ToolBarItem showDatatypes = result.addToggleButton(new BaseAction(DesignerMsg.SHOW_DATATYPES){

            public void actionPerformed(ActionEvent event) {
                DataDeclarationsPanel.this.setShowDataType(!DataDeclarationsPanel.this.showDataType());
            }
        });
        showDatatypes.setSelected(false);
        result.addSeparator();
        if (mode.equals((Object)DataDeclarationsPanelMode.SELECTABLE_MODE)) {
            ToolBarItem groupView = result.addRadioButton(new BaseAction(DesignerMsg.GROUPED_VIEW){

                public void actionPerformed(ActionEvent event) {
                    DataDeclarationsPanel.this.resetTreeRoot(false);
                }
            });
            groupView.setSelected(true);
            ToolBarItem plainView = result.addRadioButton(new BaseAction(DesignerMsg.PLAIN_VIEW){

                public void actionPerformed(ActionEvent event) {
                    DataDeclarationsPanel.this.resetTreeRoot(true);
                }
            });
            plainView.setSelected(false);
        }
        return result;
    }

    private void resetTreeRoot(boolean plainView) {
        TreeNode root = plainView ? this.createPlainRoot() : this.createGroupedRoot();
        this.tree.setIsPlainViewTree(plainView);
        this.tree.setRoot(root);
    }

    private TreeNode createPlainRoot() {
        return new DataDeclarationContainerTreeNode(this.dataDeclarationsContainer, null);
    }

    private TreeNode createGroupedRoot() {
        return new AbstractTreeNode(){

            protected void onLoading() {
                for (DataDeclarationContainer scope = DataDeclarationsPanel.this.dataDeclarationsContainer; scope != null; scope = scope.getParentScope()) {
                    if (scope.getLocalDeclarations().isEmpty() && !scope.isMutableDeclarationContainer()) continue;
                    DataDeclarationContainerTreeNode scopeNode = new DataDeclarationContainerTreeNode(scope, DataDeclarationsPanel.this.dataDeclarationsContainer);
                    this.add(scopeNode);
                }
            }
        };
    }

    private void fireModelChanged() {
        for (DataDeclarationsPanelModelListener listener : this.modelListeners) {
            listener.modelChanged();
        }
    }

    public static enum DataDeclarationsPanelMode {
        PLAIN_ONLY,
        GROUPS_ONLY,
        SELECTABLE_MODE;

    }
}

