/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.datadeclarations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationContainerTreeNode;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationEditAction;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationRemoveAction;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsSortOrder;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsTree;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.draw.Color;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationTreeNode
extends TreeNode
implements DragItem {
    private DataDeclarationContainer context;
    private static final Comparator<DataDeclaration> ASCENDING_COMPARATOR = new Comparator<DataDeclaration>(){

        @Override
        public int compare(DataDeclaration a, DataDeclaration b) {
            return a.getName().compareTo(b.getName());
        }
    };
    private static final Comparator<DataDeclaration> DESCENDING_COMPARATOR = new Comparator<DataDeclaration>(){

        @Override
        public int compare(DataDeclaration a, DataDeclaration b) {
            return b.getName().compareTo(a.getName());
        }
    };

    public DataDeclarationTreeNode(Object object) {
        super(object);
    }

    public DataDeclarationTreeNode(@NotNull DataDeclaration dataDeclaration, DataDeclarationContainer context) {
        this.context = context;
        this.setUserObject(dataDeclaration);
    }

    public Transfer[] getTransfers() {
        Transfer[] transferArray;
        if (!this.isShadowed()) {
            Transfer[] transferArray2 = new Transfer[3];
            transferArray2[0] = LocalObjectTransfer.getInstance(Sequence.class);
            transferArray2[1] = TextTransfer.getInstance();
            transferArray = transferArray2;
            transferArray2[2] = LocalObjectTransfer.getInstance(Expression.class);
        } else {
            transferArray = new Transfer[]{};
        }
        return transferArray;
    }

    public Object getObjectAs(Transfer transfer) {
        Object result = null;
        if (LocalObjectTransfer.getInstance(Sequence.class) == transfer) {
            result = this.getDeclarationsPath();
        } else if (TextTransfer.getInstance() == transfer) {
            result = this.getFullPathText();
        } else if (LocalObjectTransfer.getInstance(Expression.class) == transfer) {
            result = this.getFullPathExpression();
        }
        return result;
    }

    public String getFullPathText() {
        Expression expression = this.getFullPathExpression();
        this.getDataDeclarationsTree().appendUsedNamespaces(expression.getNamespaces());
        CatalogType type = this.getDataDeclaration().getType();
        return ExpressionHelper.getText((Expression)expression, (DataDeclarationContainer)this.getDeclarationContainer(), (CatalogType)type);
    }

    public int getColorModifiers() {
        return this.isShadowed() ? Color.LIGHT_GRAY.getRGB() : Color.BLACK.getRGB();
    }

    public String toString() {
        DataDeclaration dataDeclaration = this.getDataDeclaration();
        DataDeclarationsTree tree = this.getDataDeclarationsTree();
        String result = "";
        if (dataDeclaration != null && tree != null) {
            result = dataDeclaration.getName();
            if (tree.getShowDataType()) {
                result = result + ": " + dataDeclaration.getType().getText();
            }
        }
        return result;
    }

    public Image getIcon() {
        DataDeclaration dataDeclaration = this.getDataDeclaration();
        Image resultImage = new DataDeclarationRenderer().getIcon(dataDeclaration);
        if (resultImage != null && this.isShadowed()) {
            resultImage = IconFactory.createGreyIcon(resultImage);
        }
        return resultImage;
    }

    public DataDeclaration getDataDeclaration() {
        return (DataDeclaration)this.getUserObject();
    }

    public boolean isPredefined() {
        return this.getDataDeclaration().isPredefinedDeclaration();
    }

    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup();
        if (this.getParent() instanceof DataDeclarationContainerTreeNode && !this.isPredefined() && !this.getDataDeclarationsTree().isPlainViewTree()) {
            result.add((BaseAction)new DataDeclarationEditAction(this));
            result.add((BaseAction)new DataDeclarationRemoveAction(this));
        }
        return result;
    }

    protected void onLoading() {
        this.buildTree();
    }

    private Expression getFullPathExpression() {
        DataDeclarationContainer context = this.getDeclarationContainer();
        ExpressionMode mode = this.getDataDeclarationsTree().getExpressionMode();
        Map<String, URI> usedNamespaces = this.getDataDeclarationsTree().getUsedNamespaces();
        return ExpressionHelper.createExpressionFromParts((ExpressionMode)mode, this.getDeclarationsPath(), (DataDeclarationContainer)context, null, usedNamespaces);
    }

    private boolean isShadowed() {
        return this.context != null && this.getDataDeclaration().isShadowed(this.context);
    }

    private Sequence<DataDeclaration> getDeclarationsPath() {
        ArrayList<DataDeclaration> result = new ArrayList<DataDeclaration>();
        TreeNode parentNode = this.getParent();
        if (parentNode != null && parentNode instanceof DataDeclarationTreeNode) {
            DataDeclarationTreeNode parentDataDeclarationTreeNode = (DataDeclarationTreeNode)parentNode;
            for (DataDeclaration element : parentDataDeclarationTreeNode.getDeclarationsPath()) {
                result.add(element);
            }
        }
        result.add(this.getDataDeclaration());
        return CollectionUtils.asSequence(result);
    }

    private DataDeclarationContainer getDeclarationContainer() {
        DataDeclarationContainer result = null;
        for (TreeNode parentNode = this.getParent(); result == null && parentNode != null; parentNode = parentNode.getParent()) {
            if (!(parentNode instanceof DataDeclarationContainerTreeNode)) continue;
            result = ((DataDeclarationContainerTreeNode)parentNode).getDataDeclarationContainer();
        }
        return result;
    }

    private void buildTree() {
        if (this.getDataDeclarationsTree().canExpandDeclarations()) {
            DataDeclaration dataDeclaration = this.getDataDeclaration();
            DataDeclarationsTree tree = this.getDataDeclarationsTree();
            if (dataDeclaration != null && tree != null) {
                DataDeclarationsSortOrder order = tree.getSortOrder();
                Comparator<DataDeclaration> comparator = order.equals((Object)DataDeclarationsSortOrder.ASCENDING) ? ASCENDING_COMPARATOR : DESCENDING_COMPARATOR;
                List<DataDeclaration> children = CollectionUtils.sort(dataDeclaration.getDeclarations(), comparator);
                for (DataDeclaration child : children) {
                    DataDeclarationTreeNode childNode = new DataDeclarationTreeNode(child, null);
                    this.add(childNode);
                }
            }
        }
    }

    private DataDeclarationsTree getDataDeclarationsTree() {
        return this.getTree() != null && this.getTree() instanceof DataDeclarationsTree ? (DataDeclarationsTree)this.getTree() : null;
    }
}

