/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.datadeclarations;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationTreeNode;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationRemoveAction
extends DesignerAction {
    private DataDeclarationTreeNode node;

    public DataDeclarationRemoveAction(@NotNull DataDeclarationTreeNode node) {
        this.node = node;
        this.requires(DataDeclaration.class);
        this.setMsg(UIMsg.REMOVE);
    }

    @Override
    public boolean doIt() {
        boolean result = false;
        try {
            DataDeclarationContainer parent = this.getDataDeclaration().getDeclarationContainer();
            parent.removeDeclaration(this.getDataDeclaration());
            TreeNode parentNode = this.node.getParent();
            parentNode.unload();
            parentNode.reload();
            parentNode.expand();
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        return result;
    }

    private DataDeclaration getDataDeclaration() {
        return (DataDeclaration)this.getSelection().as(DataDeclaration.class);
    }
}

