/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.datadeclarations;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationDialog;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationTreeNode;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationEditAction
extends DesignerAction {
    private DataDeclarationTreeNode node;

    public DataDeclarationEditAction(@NotNull DataDeclarationTreeNode node) {
        this.node = node;
        this.requires(DataDeclaration.class);
        this.setMsg(UIMsg.EDIT);
    }

    @Override
    public boolean doIt() {
        boolean result = false;
        DataDeclaration dataDeclaration = this.getDataDeclaration();
        DataDeclarationContainer dataDeclarationContainer = dataDeclaration.getDeclarationContainer();
        DataDeclarationDialog dialog = new DataDeclarationDialog(Ui.getRoot(), dataDeclaration, dataDeclarationContainer.getLocalDeclarations(), ProjectUiMsg.EDIT((Msg)ProjectUiMsg.DATA_OBJECT), ProjectUiMsg.DATA_OBJECT);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            result = true;
        }
        TreeNode parentNode = this.node.getParent();
        parentNode.unload();
        parentNode.reload();
        parentNode.expand();
        return result;
    }

    private DataDeclaration getDataDeclaration() {
        return (DataDeclaration)this.getSelection().as(DataDeclaration.class);
    }
}

