/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.datadeclarations;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.TypeChooserPanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.InitializableDeclaration;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationDialog
extends OkCancelDialog {
    private DataDeclaration dataDeclaration;
    private Msg helpMsg;
    private IdentifierTextField idTextField;
    private CheckBox initializeCheckBox;
    private boolean isEdition;
    private String oldName;
    private TypeChooserPanel typeChooserPanel;
    private Sequence<DataDeclaration> usedDeclarations;

    public DataDeclarationDialog(@NotNull UiWindow parent, @NotNull DataDeclaration dataDeclaration, @NotNull Sequence<DataDeclaration> usedDeclarations, @NotNull Msg title, @NotNull Msg helpMsg) {
        super(parent, title);
        this.dataDeclaration = dataDeclaration;
        this.usedDeclarations = usedDeclarations;
        this.helpMsg = helpMsg;
        String name = dataDeclaration.getName();
        this.isEdition = DataDeclarationDialog.declarationNameExists(usedDeclarations, name);
        this.oldName = name;
        this.init();
    }

    public static String getDefaultDeclarationName(@NotNull Sequence<DataDeclaration> usedDeclarations, @NotNull String defaultNameSeed) {
        int count = 1;
        while (DataDeclarationDialog.declarationNameExists(usedDeclarations, defaultNameSeed + count)) {
            ++count;
        }
        return defaultNameSeed + count;
    }

    public static CatalogType getDefaultType() {
        return CatalogType.Default.getString();
    }

    public void setArraysEnabled(boolean enabled) {
        this.typeChooserPanel.setArraysEnabled(enabled);
    }

    public String getHelpId() {
        return this.getHelpIdWithMsg() + "." + this.helpMsg.getCode();
    }

    public void ok() {
        Msg errorMessage = this.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        this.dataDeclaration.setName(this.idTextField.getText());
        this.dataDeclaration.setType(this.typeChooserPanel.getEnsuredSelectedItem());
        if (this.isInitializable()) {
            InitializableDeclaration initializableDeclaration = (InitializableDeclaration)this.dataDeclaration;
            initializableDeclaration.setInitialize(this.initializeCheckBox.isSelected());
        }
        this.close();
    }

    private static boolean declarationNameExists(@NotNull Sequence<DataDeclaration> declarations, @NotNull String name) {
        for (DataDeclaration dataDeclaration : declarations) {
            if (!dataDeclaration.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Msg validateInput() {
        String name = this.idTextField.getText().trim();
        if (Str.isEmpty(name)) {
            return DesignerMsg.DECLARATION_NAME_IS_NULL(this.getMsg().getString());
        }
        if (!this.isEdition || !name.equals(this.oldName)) {
            try {
                if (DataDeclarationDialog.declarationNameExists(this.usedDeclarations, name)) {
                    return DesignerMsg.DECLARATION_ALREADY_DEFINED(this.getMsg().getString(), name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.typeChooserPanel.isValidType()) {
            return DesignerMsg.INVALID_TYPE(this.typeChooserPanel.getInvalidType());
        }
        return null;
    }

    private void init() {
        UiContainer contentPane = this.getContentPane();
        Panel panel = new Panel(contentPane);
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.idTextField = new IdentifierTextField((UiContainer)panel, 30, true);
        this.idTextField.setTextLimit(30);
        this.idTextField.setText(this.dataDeclaration.getName());
        ComponentCatalog catalog = this.dataDeclaration.getProject().getComponentCatalog();
        this.typeChooserPanel = TypeChooserPanel.create((UiContainer)panel, catalog);
        this.typeChooserPanel.setArraysEnabled(false);
        this.typeChooserPanel.setInitialType(this.dataDeclaration.getType(), false);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)ProjectDrawMsg.NAME));
        panel.add((UiComponent)this.idTextField, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)CoreMsg.TYPE));
        panel.add((UiComponent)this.typeChooserPanel, (Object)"growx, wrap");
        if (this.isInitializable()) {
            InitializableDeclaration initializableDeclaration = (InitializableDeclaration)this.dataDeclaration;
            this.initializeCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.AUTO_INITIALIZE, (boolean)initializableDeclaration.isInitialize());
            panel.add((UiComponent)this.initializeCheckBox, (Object)"spanx 2, wrap");
        }
        contentPane.add((UiComponent)panel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private boolean isInitializable() {
        return this.dataDeclaration instanceof InitializableDeclaration;
    }
}

