/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping.datadeclarations;

import java.util.Comparator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationContainerAddAction;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationTreeNode;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsSortOrder;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsTree;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationContainerTreeNode
extends TreeNode
implements DragItem {
    private DataDeclarationContainer context;
    private static final Comparator<DataDeclaration> ASCENDING_COMPARATOR = new Comparator<DataDeclaration>(){

        @Override
        public int compare(DataDeclaration a, DataDeclaration b) {
            return a.getName().compareTo(b.getName());
        }
    };
    private static final Comparator<DataDeclaration> DESCENDING_COMPARATOR = new Comparator<DataDeclaration>(){

        @Override
        public int compare(DataDeclaration a, DataDeclaration b) {
            return b.getName().compareTo(a.getName());
        }
    };

    public DataDeclarationContainerTreeNode(Object object) {
        super(object);
    }

    public DataDeclarationContainerTreeNode(@NotNull DataDeclarationContainer dataDeclarationContainer, DataDeclarationContainer context) {
        this.context = context;
        this.setUserObject(dataDeclarationContainer);
    }

    public Transfer[] getTransfers() {
        return new Transfer[0];
    }

    public Object getObjectAs(Transfer transfer) {
        return null;
    }

    public Image getIcon() {
        return ProjectObjectRenderer.Default.getIcon((ProjectObject)((ProjectObject)this.getUserObject()));
    }

    public String getText() {
        return ProjectObjectRenderer.Default.getLabel((ProjectObject)((ProjectObject)this.getUserObject()));
    }

    public DataDeclarationContainer getDataDeclarationContainer() {
        return (DataDeclarationContainer)this.getUserObject();
    }

    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup();
        if (this.getDataDeclarationContainer().isMutableDeclarationContainer()) {
            result.add((BaseAction)new DataDeclarationContainerAddAction(this));
        }
        return result;
    }

    protected void onLoading() {
        this.buildTree();
    }

    private void buildTree() {
        DataDeclarationContainer container = this.getDataDeclarationContainer();
        DataDeclarationsTree tree = this.getDataDeclarationsTree();
        if (container != null && tree != null) {
            DataDeclarationsSortOrder order = tree.getSortOrder();
            Comparator<DataDeclaration> comparator = order.equals((Object)DataDeclarationsSortOrder.ASCENDING) ? ASCENDING_COMPARATOR : DESCENDING_COMPARATOR;
            Sequence dataDeclarationSequence = tree.isPlainViewTree() ? container.getDeclarations() : container.getLocalDeclarations();
            List<DataDeclaration> children = CollectionUtils.sort(dataDeclarationSequence, comparator);
            for (DataDeclaration child : children) {
                DataDeclarationTreeNode childNode = new DataDeclarationTreeNode(child, this.context);
                this.add(childNode);
            }
        }
    }

    private DataDeclarationsTree getDataDeclarationsTree() {
        return this.getTree() != null && this.getTree() instanceof DataDeclarationsTree ? (DataDeclarationsTree)this.getTree() : null;
    }
}

