/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping;

import oracle.bpm.designer.argumentmapping.ArgumentMappingContainerPanel;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionFieldListener;
import oracle.bpm.designer.argumentmapping.expressionfield.SimpleExpressionField;
import oracle.bpm.designer.argumentmapping.expressionfield.XPathExpressionField;
import oracle.bpm.designer.argumentmapping.model.ArgumentAccessType;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObject;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroup;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroupListener;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class InputsOutputsGroupPanel
extends Panel {
    private ArgumentMappingObjectGroup group;
    private ArgumentAccessType panelType;

    public InputsOutputsGroupPanel(@NotNull UiContainer container, @NotNull ArgumentMappingObjectGroup group, @NotNull ArgumentAccessType panelType) {
        super(container);
        this.group = group;
        this.panelType = panelType;
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("wrap, hidemode 3, ins 0, gap 0, fillx"));
        this.setBackground(this.getParent().getBackground());
        this.makeRecyclable();
        String constraints = "growx, height " + String.valueOf(12) + "!";
        this.add(Box.createRigidArea((UiContainer)this, (Dimension)Dimension.valueOf(0, 0)), constraints);
        InputOutputContainerPanel childrenPanel = this.createChildrenPanel((UiContainer)this);
        this.add((UiComponent)childrenPanel, "growx");
        this.addListeners(childrenPanel);
    }

    private InputOutputContainerPanel createChildrenPanel(UiContainer container) {
        InputOutputContainerPanel newChildrenPanel = new InputOutputContainerPanel(container, this.panelType);
        for (ArgumentMappingObject child : this.group.getChildren()) {
            newChildrenPanel.addChild(child);
        }
        return newChildrenPanel;
    }

    private void addListeners(final @NotNull InputOutputContainerPanel childrenPanel) {
        this.group.addListener(new ArgumentMappingObjectGroupListener.ArgumentMappingObjectGroupListenerAdapter(){

            @Override
            public void childAdded(ChangeEvent e) {
                childrenPanel.addChild((ArgumentMappingObject)e.getSourceObject());
            }
        });
    }

    private static class InputOutputContainerPanel
    extends Panel {
        private ArgumentAccessType panelType;

        public InputOutputContainerPanel(@NotNull UiContainer parent, @NotNull ArgumentAccessType panelType) {
            super(parent);
            this.panelType = panelType;
            this.init();
        }

        public void addChild(@NotNull ArgumentMappingObject argumentMappingObject) {
            ExpandableInputOutputPanel childPanel = new ExpandableInputOutputPanel((UiContainer)this, argumentMappingObject, this.panelType);
            this.add((UiComponent)childPanel);
            if (argumentMappingObject.isExpanded()) {
                childPanel.expandChildrenPanel();
            }
            ArgumentMappingContainerPanel.refresh((UiComponent)this);
        }

        protected void init() {
            this.setLayout((Layout)new BoxLayout((UiContainer)this, 1));
            this.setBackground(this.getParent().getBackground());
            this.makeRecyclable();
        }
    }

    private static class ExpandableInputOutputPanel
    extends Panel {
        private ArgumentField argumentField;
        private ArgumentMappingObject argumentMappingObject;
        private InputOutputContainerPanel childrenPanel;
        private ArgumentAccessType panelType;

        public ExpandableInputOutputPanel(@NotNull UiContainer container, @NotNull ArgumentMappingObject argumentMappingObject, @NotNull ArgumentAccessType panelType) {
            super(container);
            this.argumentMappingObject = argumentMappingObject;
            this.panelType = panelType;
            this.init();
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("wrap, hidemode 3, ins 0, gap 0, fillx"));
            this.setBackground(this.getParent().getBackground());
            String constraints = "growx, height " + String.valueOf(25) + "!";
            if (this.panelType == this.argumentMappingObject.getGroup().getType()) {
                this.argumentField = new ArgumentField(this, this.argumentMappingObject, this.panelType);
                this.add((UiComponent)this.argumentField, constraints);
            } else {
                this.add(Box.createRigidArea((UiContainer)this, (Dimension)Dimension.valueOf(0, 0)), constraints);
            }
            this.addParentNodeListener();
        }

        private InputOutputContainerPanel createChildrenPanel(ExpandableInputOutputPanel container) {
            InputOutputContainerPanel newChildrenPanel = new InputOutputContainerPanel((UiContainer)container, this.panelType);
            for (ArgumentMappingObject child : this.argumentMappingObject.getChildren()) {
                newChildrenPanel.addChild(child);
            }
            return newChildrenPanel;
        }

        private void addParentNodeListener() {
            this.argumentMappingObject.addNodeListener(new ArgumentMappingObjectListener.ArgumentMappingObjectListenerAdapter(){

                @Override
                public void nodeExpanded() {
                    ExpandableInputOutputPanel.this.expandChildrenPanel();
                }

                @Override
                public void nodeCollapsed() {
                    ExpandableInputOutputPanel.this.collapseChildrenPanel();
                }

                @Override
                public void nodeDeleted() {
                    ExpandableInputOutputPanel.this.remove();
                }
            });
        }

        private void expandChildrenPanel() {
            this.setChildrenPanelVisible(true);
        }

        private void collapseChildrenPanel() {
            this.setChildrenPanelVisible(false);
        }

        private void setChildrenPanelVisible(boolean visible) {
            if (this.argumentField != null) {
                this.argumentField.setEnabled(!visible);
            }
            this.getChildrenPanel().setVisible(visible);
            ArgumentMappingContainerPanel.refresh((UiComponent)this);
        }

        private InputOutputContainerPanel getChildrenPanel() {
            if (this.childrenPanel == null) {
                this.childrenPanel = this.createChildrenPanel(this);
                this.add((UiComponent)this.childrenPanel, "growx");
            }
            return this.childrenPanel;
        }

        private void remove() {
            this.getParent().remove((UiComponent)this);
            ArgumentMappingContainerPanel.refresh((UiComponent)this);
        }

        private static class ArgumentField
        extends Panel {
            private ArgumentMappingObject argumentMappingObject;
            private ExpressionField expressionField;
            private ArgumentAccessType panelType;

            public ArgumentField(@NotNull ExpandableInputOutputPanel parent, @NotNull ArgumentMappingObject argumentMappingObject, @NotNull ArgumentAccessType panelType) {
                super((UiContainer)parent);
                this.argumentMappingObject = argumentMappingObject;
                this.panelType = panelType;
                this.init();
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.expressionField.setEnabled(enabled);
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fillx"));
                this.setBackground(this.getParent().getBackground());
                if (this.panelType.equals((Object)ArgumentAccessType.OUTPUT)) {
                    this.add((UiComponent)this.createArrowImage((UiContainer)this), "gap 5");
                }
                this.expressionField = this.createExpressionField((UiContainer)this, this.argumentMappingObject);
                this.add(this.expressionField.getUiComponent(), "growx, gap 5");
                if (this.panelType == ArgumentAccessType.INPUT || this.panelType == ArgumentAccessType.CUSTOM_OUTPUT) {
                    this.add((UiComponent)this.createArrowImage((UiContainer)this), "gap 5");
                }
            }

            private ExpressionField createExpressionField(@NotNull UiContainer container, final @NotNull ArgumentMappingObject argumentMappingObject) {
                Panel field;
                ExpressionField.ExpressionFieldMode expressionFieldMode;
                ExpressionMode expressionMode = argumentMappingObject.getGroup().getExpressionMode();
                DataDeclarationContainer context = argumentMappingObject.getGroup().getVariablesContext();
                boolean showExpressionBuilder = argumentMappingObject.getGroup().showExpressionBuilder();
                ExpressionField.ExpressionFieldMode expressionFieldMode2 = expressionFieldMode = argumentMappingObject.getGroup().isQuery() ? ExpressionField.ExpressionFieldMode.QUERY : ExpressionField.ExpressionFieldMode.EXPRESSION;
                if (expressionMode.equals(ExpressionMode.SIMPLE)) {
                    CatalogType resultType = expressionMode.equals(ExpressionMode.SIMPLE) ? argumentMappingObject.getDataType() : null;
                    field = new SimpleExpressionField(container, expressionFieldMode, context, resultType, showExpressionBuilder);
                } else {
                    field = new XPathExpressionField(container, context);
                }
                field.setExpression(argumentMappingObject.getRelatedExpression());
                field.addListener(new ExpressionFieldListener((ExpressionField)field){
                    final /* synthetic */ ExpressionField val$field;
                    {
                        this.val$field = expressionField;
                    }

                    @Override
                    public void expressionChanged() {
                        argumentMappingObject.setRelatedExpression(this.val$field.getExpression());
                    }
                });
                argumentMappingObject.addNodeListener(new ArgumentMappingObjectListener.ArgumentMappingObjectListenerAdapter((ExpressionField)field, argumentMappingObject){
                    final /* synthetic */ ExpressionField val$field;
                    final /* synthetic */ ArgumentMappingObject val$argumentMappingObject;
                    {
                        this.val$field = expressionField;
                        this.val$argumentMappingObject = argumentMappingObject;
                    }

                    @Override
                    public void relatedExpressionChanged() {
                        this.val$field.setExpression(this.val$argumentMappingObject.getRelatedExpression());
                    }

                    @Override
                    public void revalidate() {
                        this.val$field.revalidateExpression();
                    }
                });
                return field;
            }

            private Label createArrowImage(UiContainer container) {
                return Label.create((UiContainer)container, (Image)Image.create((Msg)DesignerMsg.ARROW_DOTTED));
            }
        }
    }
}

