/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping;

import java.util.Iterator;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.ArgumentMappingContainerPanel;
import oracle.bpm.designer.argumentmapping.ArgumentsGroupPanel;
import oracle.bpm.designer.argumentmapping.InputsOutputsGroupPanel;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsPanel;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsPanelModelListener;
import oracle.bpm.designer.argumentmapping.model.ArgumentAccessType;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingModel;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObject;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroup;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroupListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Cast;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ComplexArgumentMappingPanel
extends Panel {
    private ArgumentMappingModel model;
    public static final int HEADER_HEIGHT = 12;
    public static final int ROW_HEIGHT = 25;
    public static final int HORIZONTAL_GAP = 5;
    public static final Color ARGUMENTS_PANEL_BACKGROUND_COLOR = Color.valueOf((int)234, (int)234, (int)234);
    public static final Color ARGUMENTS_PANEL_BORDER_COLOR = Color.valueOf((int)216, (int)217, (int)217);
    public static final Color MASTER_PANEL_BACKGROUND_COLOR = Color.WHITE;

    public ComplexArgumentMappingPanel(@NotNull UiContainer parent, @NotNull ArgumentMappingModel model) {
        super(parent);
        this.model = model;
        this.init();
    }

    public ArgumentMappingModel getModel() {
        return this.model;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.setBackground(MASTER_PANEL_BACKGROUND_COLOR);
        SplitPane splitPane = new SplitPane((UiContainer)this);
        splitPane.setBackground(splitPane.getParent().getBackground());
        this.add((UiComponent)splitPane, "grow");
        ScrollPane argumentMapperScrollPane = this.createArgumentMapperScrollPane((UiContainer)splitPane, this.model, DesignerMsg.DATA_ASSOCIATIONS_DRAG_HINT);
        splitPane.add((UiComponent)argumentMapperScrollPane);
        ScrollPane variablesScrollPane = this.createVariablesScrollPane((UiContainer)splitPane);
        splitPane.add((UiComponent)variablesScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setLeftComponent((UiComponent)argumentMapperScrollPane);
        splitPane.setRightComponent((UiComponent)variablesScrollPane);
        splitPane.setResizeWeight(0.75);
    }

    private ScrollPane createArgumentMapperScrollPane(@NotNull UiContainer container, @NotNull ArgumentMappingModel model, Msg toolTip) {
        ScrollPane argumentMapperScrollPane = new ScrollPane(container);
        argumentMapperScrollPane.setBackground(argumentMapperScrollPane.getParent().getBackground());
        Panel argumentMapperPanel = new Panel((UiContainer)argumentMapperScrollPane);
        argumentMapperScrollPane.add((UiComponent)argumentMapperPanel);
        argumentMapperPanel.setLayout((Layout)new MigLayout("hidemode 2, fill, ins 10, gap 0"));
        argumentMapperPanel.setBackground(argumentMapperPanel.getParent().getBackground());
        argumentMapperPanel.add((UiComponent)this.createToolbar((UiContainer)argumentMapperPanel), (Object)"north, growx");
        if (toolTip != null) {
            argumentMapperPanel.add((UiComponent)Label.createWithNoColon((UiContainer)argumentMapperPanel, (Msg)toolTip), (Object)"north");
        }
        boolean inputsAdded = false;
        if (model.hasInputs()) {
            ArgumentMappingContainerPanel inputsPanel = this.createInputPanel((UiContainer)argumentMapperPanel);
            argumentMapperPanel.add((UiComponent)inputsPanel, (Object)"gapy 5, growx, center, width 200:200");
            inputsAdded = true;
        }
        if (model.getInputsGroup() != null && !model.getInputsGroup().getChildren().isEmpty() || model.getOuputsGroup() != null && !model.getOuputsGroup().getChildren().isEmpty()) {
            ArgumentMappingContainerPanel argumentsPanel = this.createArgumentsPanel((UiContainer)argumentMapperPanel, model.getVariablesProvider());
            String constraints = "gapy 5, center, growx";
            if (!inputsAdded) {
                constraints = constraints + ", skip 1";
            }
            argumentMapperPanel.add((UiComponent)argumentsPanel, (Object)constraints);
        }
        if (model.hasOutputs()) {
            ArgumentMappingContainerPanel outputsPanel = this.createOutputPanel((UiContainer)argumentMapperPanel);
            argumentMapperPanel.add((UiComponent)outputsPanel, (Object)"gapy 5, growx, center, width 200:200");
            argumentMapperPanel.add((UiComponent)this.createCustomSourcesPanel((UiContainer)argumentMapperPanel), (Object)"newline, skip 1, growx, top, width 200:200");
            argumentMapperPanel.add((UiComponent)this.createCustomTargetsPanel((UiContainer)argumentMapperPanel), (Object)"growx, top");
        }
        argumentMapperScrollPane.setView((UiComponent)argumentMapperPanel);
        return argumentMapperScrollPane;
    }

    private ScrollPane createVariablesScrollPane(@NotNull UiContainer container) {
        ScrollPane variablesScrollPane = new ScrollPane(container);
        Panel variablesPanelContainer = new Panel((UiContainer)variablesScrollPane);
        variablesPanelContainer.setLayout((Layout)new MigLayout("gap 0, ins 0, align center, center, fill"));
        variablesScrollPane.add((UiComponent)variablesPanelContainer);
        variablesScrollPane.setView((UiComponent)variablesPanelContainer);
        DataDeclarationsPanel variablesPanel = this.createVariablesPanel((UiContainer)variablesPanelContainer);
        variablesPanelContainer.add((UiComponent)variablesPanel, (Object)"grow");
        return variablesScrollPane;
    }

    private ToolBar createToolbar(UiContainer container) {
        ToolBar toolbar = new ToolBar(container);
        if (this.getModel().hasInputs() && !this.getModel().getInputsGroup().getChildren().isEmpty() || this.getModel().hasOutputs() && !this.getModel().getOuputsGroup().getChildren().isEmpty()) {
            toolbar.add(new BaseAction(DesignerMsg.AUTOMAPPING){

                public void actionPerformed(ActionEvent event) {
                    ComplexArgumentMappingPanel.this.model.automapVariables();
                }
            });
        }
        if (this.model.hasOutputs()) {
            final boolean customAssignmentsEnabled = !this.model.getCustomsGroup().getChildren().isEmpty() || this.model.getInputsGroup() == null && this.model.getOuputsGroup() != null && this.model.getOuputsGroup().getChildren().isEmpty();
            ToolBarItem customAssignmentsButton = toolbar.addToggleButton(new BaseAction(DesignerMsg.CUSTOM_ASSIGNMENTS){
                boolean selected;
                {
                    super(x0);
                    this.selected = customAssignmentsEnabled;
                }

                public void actionPerformed(ActionEvent event) {
                    this.selected = !this.selected;
                    ComplexArgumentMappingPanel.this.setCustomAssignmentsEnabled(this.selected);
                }
            });
            this.setCustomAssignmentsEnabled(customAssignmentsEnabled);
            customAssignmentsButton.setSelected(customAssignmentsEnabled);
        }
        return toolbar;
    }

    private void setCustomAssignmentsEnabled(boolean enabled) {
        this.model.setCustomAssignmentsEnabled(enabled);
    }

    private ArgumentMappingContainerPanel createInputPanel(UiContainer container) {
        return this.createIOPanel(container, DesignerMsg.INPUTS.getString(), ArgumentAccessType.INPUT);
    }

    private ArgumentMappingContainerPanel createOutputPanel(UiContainer container) {
        return this.createIOPanel(container, DesignerMsg.OUTPUTS.getString(), ArgumentAccessType.OUTPUT);
    }

    private ArgumentMappingContainerPanel createCustomSourcesPanel(UiContainer container) {
        final ArgumentMappingContainerPanel result = new ArgumentMappingContainerPanel(container, null, null, MASTER_PANEL_BACKGROUND_COLOR, MASTER_PANEL_BACKGROUND_COLOR);
        InputsOutputsGroupPanel inPanel = new InputsOutputsGroupPanel((UiContainer)result.getMainContainerPanel(), this.model.getCustomsGroup(), ArgumentAccessType.CUSTOM_OUTPUT);
        result.getMainContainerPanel().add((UiComponent)inPanel, (Object)"growx");
        final ArgumentMappingObjectGroup modelGroup = this.model.getCustomsGroup();
        modelGroup.addListener(new ArgumentMappingObjectGroupListener.ArgumentMappingObjectGroupListenerAdapter(){

            @Override
            public void groupChanged() {
                result.setVisible(modelGroup.isVisible() && !modelGroup.getChildren().isEmpty());
            }
        });
        result.setVisible(modelGroup.isVisible() && !modelGroup.getChildren().isEmpty());
        return result;
    }

    private ArgumentMappingContainerPanel createCustomTargetsPanel(@NotNull UiContainer container) {
        final ArgumentMappingContainerPanel result = new ArgumentMappingContainerPanel(container, DesignerMsg.CUSTOM_ASSIGNMENTS_HINT.getString(), Image.create((Msg)DesignerMsg.CUSTOM_ASSIGNMENTS), ARGUMENTS_PANEL_BORDER_COLOR, ARGUMENTS_PANEL_BACKGROUND_COLOR);
        final ArgumentMappingObjectGroup modelGroup = this.model.getCustomsGroup();
        ArgumentsGroupPanel inPanel = new ArgumentsGroupPanel((UiContainer)result.getMainContainerPanel(), modelGroup);
        result.getMainContainerPanel().add((UiComponent)inPanel);
        modelGroup.addListener(new ArgumentMappingObjectGroupListener.ArgumentMappingObjectGroupListenerAdapter(){

            @Override
            public void groupChanged() {
                result.setVisible(modelGroup.isVisible());
            }
        });
        result.setVisible(modelGroup.isVisible());
        new DropTargetHandler((UiComponent)result, DndAction.COPY_OR_MOVE){

            public void drop(Object data, Transfer type, Point point, DndAction dndAction) {
                if (type == LocalObjectTransfer.getInstance(Sequence.class)) {
                    Sequence dataDeclarationsPath = (Sequence)Cast.force(data);
                    DataDeclaration dataDeclaration = this.getRoot(dataDeclarationsPath);
                    ArgumentMappingObject child = modelGroup.createChild(dataDeclaration);
                    modelGroup.addChild(child);
                    ArgumentMappingObject argument = modelGroup.findChild(dataDeclarationsPath);
                    argument.expandParents();
                }
            }

            public Transfer[] getTransfers() {
                return new Transfer[]{LocalObjectTransfer.getInstance(Sequence.class)};
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                if (transfer.equals(LocalObjectTransfer.getInstance(Sequence.class))) {
                    Sequence dataDeclarationsPath = (Sequence)Cast.force(data);
                    ArgumentMappingObject argument = modelGroup.findChild(dataDeclarationsPath);
                    DataDeclaration leafDeclaration = this.getLeaf(dataDeclarationsPath);
                    return argument == null && leafDeclaration != null && !leafDeclaration.isReadOnly();
                }
                return false;
            }

            private DataDeclaration getRoot(@NotNull Sequence<DataDeclaration> dataDeclarationsPath) {
                DataDeclaration result = null;
                if (!dataDeclarationsPath.isEmpty()) {
                    result = dataDeclarationsPath.iterator().next();
                }
                return result;
            }

            private DataDeclaration getLeaf(Sequence<DataDeclaration> dataDeclarationsPath) {
                DataDeclaration result = null;
                Iterator<DataDeclaration> i$ = dataDeclarationsPath.iterator();
                while (i$.hasNext()) {
                    DataDeclaration part;
                    result = part = i$.next();
                }
                return result;
            }
        };
        return result;
    }

    private ArgumentMappingContainerPanel createIOPanel(@NotNull UiContainer container, String title, @NotNull ArgumentAccessType accessType) {
        final ArgumentMappingContainerPanel result = new ArgumentMappingContainerPanel(container, title, null, MASTER_PANEL_BACKGROUND_COLOR, MASTER_PANEL_BACKGROUND_COLOR);
        if (this.model.hasInputs()) {
            InputsOutputsGroupPanel inPanel = new InputsOutputsGroupPanel((UiContainer)result.getMainContainerPanel(), this.model.getInputsGroup(), accessType);
            result.getMainContainerPanel().add((UiComponent)inPanel, (Object)"growx");
        }
        if (this.model.hasOutputs()) {
            InputsOutputsGroupPanel outPanel = new InputsOutputsGroupPanel((UiContainer)result.getMainContainerPanel(), this.model.getOuputsGroup(), accessType);
            result.getMainContainerPanel().add((UiComponent)outPanel, (Object)"growx");
        }
        final ArgumentMappingObjectGroup modelGroup = accessType == ArgumentAccessType.INPUT ? this.model.getInputsGroup() : this.model.getOuputsGroup();
        modelGroup.addListener(new ArgumentMappingObjectGroupListener.ArgumentMappingObjectGroupListenerAdapter(){

            @Override
            public void groupChanged() {
                result.setVisible(!modelGroup.getChildren().isEmpty());
            }
        });
        result.setVisible(!modelGroup.getChildren().isEmpty());
        return result;
    }

    private ArgumentMappingContainerPanel createArgumentsPanel(@NotNull UiContainer container, @NotNull DataDeclarationContainer dataDeclarationContainer) {
        ArgumentMappingContainerPanel result = new ArgumentMappingContainerPanel(container, ProjectObjectRenderer.Default.getLabel((ProjectObject)dataDeclarationContainer), ProjectObjectRenderer.Default.getIcon((ProjectObject)dataDeclarationContainer), ARGUMENTS_PANEL_BORDER_COLOR, ARGUMENTS_PANEL_BACKGROUND_COLOR);
        if (this.model.hasInputs()) {
            ArgumentsGroupPanel inPanel = new ArgumentsGroupPanel((UiContainer)result.getMainContainerPanel(), this.model.getInputsGroup());
            result.getMainContainerPanel().add((UiComponent)inPanel);
        }
        if (this.model.hasOutputs()) {
            ArgumentsGroupPanel outPanel = new ArgumentsGroupPanel((UiContainer)result.getMainContainerPanel(), this.model.getOuputsGroup());
            result.getMainContainerPanel().add((UiComponent)outPanel);
        }
        return result;
    }

    private DataDeclarationsPanel createVariablesPanel(UiContainer container) {
        DataDeclarationsPanel panel = new DataDeclarationsPanel(container, this.model.getVariablesProvider(), DataDeclarationsPanel.DataDeclarationsPanelMode.SELECTABLE_MODE, true);
        panel.setExpressionMode(this.getModel().getExpressionMode());
        panel.addModelListener(new DataDeclarationsPanelModelListener(){

            @Override
            public void modelChanged() {
                ComplexArgumentMappingPanel.this.getModel().revalidate();
            }
        });
        return panel;
    }
}

