/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping;

import oracle.bpm.designer.argumentmapping.ComplexArgumentMappingPanel;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ComplexArgumentMappingDialog
extends OkCancelDialog {
    private ArgumentMappingModel argumentMappingModel;
    private DataAssociationSet dataAssociationInputSet;
    private DataAssociationSet dataAssociationOutputSet;

    public ComplexArgumentMappingDialog(@NotNull UiWindow parent, @NotNull ExpressionMode mode, DataAssociationSet dataAssociationInputSet, DataAssociationSet dataAssociationOutputSet) {
        super(parent);
        this.dataAssociationInputSet = dataAssociationInputSet;
        this.dataAssociationOutputSet = dataAssociationOutputSet;
        this.initModel(mode);
        this.initUI();
    }

    public String getHelpId() {
        return super.getHelpId() + "." + this.argumentMappingModel.getExpressionMode().name();
    }

    public void ok() {
        this.argumentMappingModel.revalidate();
        Msg errorMessage = this.argumentMappingModel.validate();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        if (this.dataAssociationInputSet != null) {
            this.dataAssociationInputSet.clearDataAssociations();
            for (DataAssociation da : this.argumentMappingModel.getInputDataAssociations()) {
                this.dataAssociationInputSet.addDataAssociation(da);
            }
        }
        if (this.dataAssociationOutputSet != null) {
            this.dataAssociationOutputSet.clearDataAssociations();
            for (DataAssociation da : this.argumentMappingModel.getOutputDataAssociations()) {
                this.dataAssociationOutputSet.addDataAssociation(da);
            }
            for (DataAssociation da : this.argumentMappingModel.getCustomDataAssociations()) {
                this.dataAssociationOutputSet.addDataAssociation(da);
            }
        }
        this.close();
    }

    private void initModel(@NotNull ExpressionMode mode) {
        this.argumentMappingModel = new ArgumentMappingModel(this.dataAssociationInputSet, this.dataAssociationOutputSet, mode);
    }

    private void initUI() {
        this.setTitle(DesignerMsg.DATA_ASSOCIATIONS.getString());
        UiContainer container = this.getContentPane();
        Panel masterPanel = new Panel(container);
        masterPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        container.add((UiComponent)masterPanel);
        ComplexArgumentMappingPanel complexArgumentMappingPanel = new ComplexArgumentMappingPanel((UiContainer)masterPanel, this.argumentMappingModel);
        masterPanel.add((UiComponent)complexArgumentMappingPanel, (Object)"grow");
        this.setSize(900, 500);
        this.setLocationRelativeTo((UiComponent)this.getParent());
        if (this.argumentMappingModel.hasInvalidArgumentAssociations()) {
            MessageDialog.showNotice((Msg)DesignerMsg.DATA_ASSOCIATIONS, (Msg)DesignerMsg.INVALID_ARGUMENT_DATA_ASSOCIATIONS);
        }
    }
}

