/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping;

import oracle.bpm.designer.argumentmapping.ArgumentMappingContainerPanel;
import oracle.bpm.designer.argumentmapping.model.ArgumentAccessType;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObject;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroup;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectGroupListener;
import oracle.bpm.designer.argumentmapping.model.ArgumentMappingObjectListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

class ArgumentsGroupPanel
extends Panel {
    private ArgumentMappingObjectGroup group;

    public ArgumentsGroupPanel(@NotNull UiContainer container, @NotNull ArgumentMappingObjectGroup group) {
        super(container);
        this.group = group;
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("wrap, hidemode 3, ins 0, gap 0, fill"));
        this.setBackground(this.getParent().getBackground());
        this.makeRecyclable();
        ArgumentsSeparatorPanel separatorPanel = this.createArgumentsSeparatorPanel(this.group.getName());
        this.getParent().add((UiComponent)separatorPanel, (Object)("growx, height " + String.valueOf(12) + "!"));
        ArgumentContainerPanel childrenPanel = this.createChildrenPanel((UiContainer)this);
        this.add((UiComponent)childrenPanel);
        this.addListeners(childrenPanel);
    }

    private ArgumentsSeparatorPanel createArgumentsSeparatorPanel(String title) {
        return new ArgumentsSeparatorPanel((UiContainer)this, title);
    }

    private ArgumentContainerPanel createChildrenPanel(UiContainer container) {
        ArgumentContainerPanel newChildrenPanel = new ArgumentContainerPanel(container);
        for (ArgumentMappingObject child : this.group.getChildren()) {
            newChildrenPanel.addChild(child);
        }
        return newChildrenPanel;
    }

    private void addListeners(final @NotNull ArgumentContainerPanel childrenPanel) {
        this.group.addListener(new ArgumentMappingObjectGroupListener.ArgumentMappingObjectGroupListenerAdapter(){

            @Override
            public void childAdded(ChangeEvent e) {
                childrenPanel.addChild((ArgumentMappingObject)e.getSourceObject());
            }
        });
    }

    private static class ExpandableArgumentPanel
    extends Panel {
        private ArgumentMappingObject argumentMappingObject;
        private ArgumentContainerPanel childrenArgumentContainer;
        private Label expandIcon;
        private Label label;

        public ExpandableArgumentPanel(UiContainer parent, ArgumentMappingObject argumentMappingObject) {
            super(parent);
            this.argumentMappingObject = argumentMappingObject;
            this.init();
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("wrap, hidemode 3, ins 0, gap 0, fill"));
            this.setBackground(this.getParent().getBackground());
            this.add((UiComponent)this.createLabelPanel((UiContainer)this), "growx, height " + String.valueOf(25) + "!");
            this.argumentMappingObject.addNodeListener(new ArgumentMappingObjectListener.ArgumentMappingObjectListenerAdapter(){

                @Override
                public void nodeExpanded() {
                    ExpandableArgumentPanel.this.expand();
                }

                @Override
                public void nodeCollapsed() {
                    ExpandableArgumentPanel.this.collapse();
                }

                @Override
                public void nodeDeleted() {
                    ExpandableArgumentPanel.this.remove();
                }
            });
        }

        private Panel createLabelPanel(UiContainer container) {
            Panel labelPanel = new Panel(container);
            labelPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
            labelPanel.setBackground(this.getParent().getBackground());
            if (this.argumentMappingObject.hasChildren()) {
                this.expandIcon = this.createExpandIcon((UiContainer)labelPanel);
                labelPanel.add((UiComponent)this.expandIcon, (Object)"width 15, center");
                this.setExpandIcon(this.argumentMappingObject.isExpanded());
            }
            this.label = this.createLabel((UiContainer)labelPanel);
            String constraints = "center, growx";
            if (this.expandIcon == null) {
                constraints = constraints + ", gapx 15";
            }
            labelPanel.add((UiComponent)this.label, (Object)constraints);
            if (this.argumentMappingObject.isRoot() && this.argumentMappingObject.getGroup().getType() == ArgumentAccessType.CUSTOM_OUTPUT) {
                labelPanel.add((UiComponent)this.createRemoveButton((UiContainer)labelPanel, this.argumentMappingObject));
            }
            return labelPanel;
        }

        private void remove() {
            this.getParent().remove((UiComponent)this);
            ArgumentMappingContainerPanel.refresh((UiComponent)this);
        }

        private ArgumentContainerPanel createChildrenArgumentsContainer(UiContainer container) {
            ArgumentContainerPanel newChildrenArgumentContainer = new ArgumentContainerPanel(container);
            for (ArgumentMappingObject child : this.argumentMappingObject.getChildren()) {
                newChildrenArgumentContainer.addChild(child);
            }
            return newChildrenArgumentContainer;
        }

        private Label createLabel(UiContainer container) {
            Label newLabel = Label.createWithNoColon((UiContainer)container, (Msg)Msg.QUOTE(this.argumentMappingObject.getText()));
            newLabel.setIcon(this.argumentMappingObject.getIcon());
            newLabel.setFont(newLabel.getFont().plain());
            newLabel.setToolTipText(Msg.QUOTE(this.argumentMappingObject.getDataType().getText()));
            return newLabel;
        }

        private Label createExpandIcon(UiContainer container) {
            Label newExpandIcon = Label.create((UiContainer)container);
            newExpandIcon.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (ExpandableArgumentPanel.this.argumentMappingObject.isExpanded()) {
                        ExpandableArgumentPanel.this.argumentMappingObject.collapse();
                    } else {
                        ExpandableArgumentPanel.this.argumentMappingObject.expand();
                    }
                }
            });
            return newExpandIcon;
        }

        private Button createRemoveButton(@NotNull UiContainer container, final @NotNull ArgumentMappingObject object) {
            Button result = Button.createIconic((UiContainer)container, (Msg)DesignerMsg.REMOVE);
            result.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    object.delete();
                }
            });
            return result;
        }

        private void setExpandIcon(boolean expanded) {
            if (this.expandIcon != null) {
                this.expandIcon.setIcon(expanded ? UIMsg.TREE_MINUS : UIMsg.TREE_PLUS);
            }
        }

        private void setLabelEnabled(boolean enabled) {
            if (this.label != null) {
                this.label.setEnabled(enabled);
            }
        }

        private void expand() {
            this.setChildrenExpanded(true);
        }

        private void collapse() {
            this.setChildrenExpanded(false);
        }

        private void setChildrenExpanded(boolean expanded) {
            this.getChildrenArgumentContainer().setVisible(expanded);
            this.setExpandIcon(expanded);
            this.setLabelEnabled(!expanded);
            ArgumentMappingContainerPanel.refresh((UiComponent)this);
        }

        private ArgumentContainerPanel getChildrenArgumentContainer() {
            if (this.childrenArgumentContainer == null) {
                this.childrenArgumentContainer = this.createChildrenArgumentsContainer((UiContainer)this);
                this.add((UiComponent)this.childrenArgumentContainer, "gap 10");
            }
            return this.childrenArgumentContainer;
        }
    }

    private static class ArgumentsSeparatorPanel
    extends Panel {
        public ArgumentsSeparatorPanel(UiContainer parent, String title) {
            super(parent);
            this.init(title);
        }

        private void init(String title) {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0", "[grow, fill]2[pref!]2[grow, fill]"));
            this.setBackground(this.getParent().getBackground());
            this.add((UiComponent)this.createSeparatorLine((UiContainer)this));
            Label label = Label.createWithNoColon((UiContainer)this, (Msg)Msg.QUOTE(title));
            label.setFont(label.getFont().plain().smaller(2));
            label.setEnabled(false);
            this.add((UiComponent)label);
            this.add((UiComponent)this.createSeparatorLine((UiContainer)this));
        }

        private Separator createSeparatorLine(UiContainer container) {
            Separator separator = new Separator(container);
            separator.setForeground(Color.LIGHT_GRAY);
            return separator;
        }
    }

    private static class ArgumentContainerPanel
    extends Panel {
        public ArgumentContainerPanel(@NotNull UiContainer parent) {
            super(parent);
            this.init();
        }

        public void addChild(@NotNull ArgumentMappingObject argumentMappingObject) {
            ExpandableArgumentPanel childPanel = new ExpandableArgumentPanel((UiContainer)this, argumentMappingObject);
            this.add((UiComponent)childPanel);
            if (argumentMappingObject.isExpanded()) {
                childPanel.expand();
            }
            ArgumentMappingContainerPanel.refresh((UiComponent)this);
        }

        private void init() {
            this.setLayout((Layout)new BoxLayout((UiContainer)this, 1));
            this.setBackground(this.getParent().getBackground());
            this.makeRecyclable();
        }
    }
}

