/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentmapping;

import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.CompoundBorder;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.border.RoundedEdgeBorder;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class ArgumentMappingContainerPanel
extends Panel {
    private Panel mainContainerPanel;

    public ArgumentMappingContainerPanel(@NotNull UiContainer parent, String title, Image icon, @NotNull Color borderColor, @NotNull Color backgroundColor) {
        super(parent);
        this.makeRecyclable();
        this.setLayout((Layout)new BoxLayout((UiContainer)this, 1));
        this.setBorder((Border)new CompoundBorder((Border)new EmptyBorder(2, 2, 2, 2), (Border)new RoundedEdgeBorder(20, 20, borderColor)));
        this.setBackground(this.getParent().getBackground());
        Panel borderPanel = new Panel((UiContainer)this);
        borderPanel.setLayout((Layout)new BoxLayout((UiContainer)this, 1));
        borderPanel.setBorder((Border)new CompoundBorder((Border)new EmptyBorder(5, 5, 5, 5), (Border)new RoundedEdgeBorder(15, 15, backgroundColor)));
        borderPanel.setBackground(borderColor);
        this.add((UiComponent)borderPanel);
        this.mainContainerPanel = new Panel((UiContainer)borderPanel);
        this.mainContainerPanel.setLayout((Layout)new MigLayout("wrap, ins 0, gap 0, fillx"));
        this.mainContainerPanel.setBackground(backgroundColor);
        borderPanel.add((UiComponent)this.mainContainerPanel);
        this.mainContainerPanel.add((UiComponent)this.createTitle((UiContainer)this.mainContainerPanel, title, icon), (Object)("align center, height " + String.valueOf(25) + "!"));
    }

    public static void refresh(@NotNull UiComponent component) {
        for (UiComponent parent = component; parent != null; parent = parent.getParent()) {
            parent.revalidate();
            if (!(parent instanceof ArgumentMappingContainerPanel)) continue;
            return;
        }
    }

    public Panel getMainContainerPanel() {
        return this.mainContainerPanel;
    }

    private Panel createTitle(@NotNull UiContainer container, String titleString, Image icon) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("ins 0, gap 0"));
        panel.setBackground(panel.getParent().getBackground());
        if (icon != null) {
            Label image = Label.create((UiContainer)panel, (Image)icon);
            panel.add((UiComponent)image, (Object)"gapright 5");
        }
        if (titleString != null) {
            Label label = Label.createWithNoColon((UiContainer)panel, (Msg)Msg.QUOTE(titleString));
            label.setForeground(Color.GRAY);
            panel.add((UiComponent)label);
        }
        return panel;
    }
}

