/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.animation;

import oracle.bpm.designer.Domain;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import org.jetbrains.annotations.NotNull;

public class Animator {
    private static final int MAX_PRECISION = 4;
    private static final int AREA_PRECENTAGE_PRECISION = 4;
    private static final int ANIMATION_DELAY = 30;

    public static void move(@NotNull Domain domain, @NotNull DrawableFeedback feedback, @NotNull Point target, int speed) {
        Point delta = target.sub(feedback.getLocation());
        Animator.addMoveEventToQueue(domain, feedback, speed, delta.div(speed));
    }

    public static void resize(@NotNull Domain domain, @NotNull Controller container, @NotNull Drawable feedback, @NotNull Dimension size, int speed) {
        Dimension delta = size.sub(feedback.getBounds(domain.getDrawContext()).getSize());
        Dimension precision = size.div(4);
        Animator.addResizeEventToQueue(domain, container, feedback, speed, delta.div(speed), precision);
    }

    private static void addMoveEventToQueue(final @NotNull Domain domain, final @NotNull DrawableFeedback feedback, final int speed, final @NotNull Point delta) {
        if (delta.distanceSq(Point.ORIGIN) > 16.0) {
            Timer timer = new Timer(30, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DrawContext context = domain.getDrawContext();
                    Rectangle prev = feedback.getBounds(context);
                    feedback.setLocation(feedback.getLocation().add(delta.mul(speed - 1)));
                    Rectangle post = feedback.getBounds(context);
                    domain.getCanvas().paintImmediately(prev.union(post));
                    Animator.addMoveEventToQueue(domain, feedback, speed, delta.div(speed));
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            feedback.remove();
            domain.getCanvas().repaint();
        }
    }

    private static void addResizeEventToQueue(final @NotNull Domain domain, final @NotNull Controller container, final @NotNull Drawable feedback, final int speed, final @NotNull Dimension delta, final @NotNull Dimension precision) {
        if (delta.sqValue() > precision.sqValue()) {
            Timer timer = new Timer(30, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DrawContext context = domain.getDrawContext();
                    Rectangle prev = feedback.getBounds(context);
                    Dimension update = delta.mul(speed - 1);
                    feedback.setWidth(context, feedback.getWidth(context) + update.getWidth());
                    feedback.setHeight(context, feedback.getHeight(context) + update.getHeight());
                    Rectangle post = feedback.getBounds(context);
                    domain.getCanvas().paintImmediately(prev.union(post).expand(3));
                    Animator.addResizeEventToQueue(domain, container, feedback, speed, delta.div(speed), precision);
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            feedback.remove();
            container.refresh();
            domain.getCanvas().repaint();
        }
    }
}

