/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.designer.activityguide.MilestonePropertiesPanel;
import oracle.bpm.designer.validator.ValidationException;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;

public class NewMilestoneDialog
extends OkCancelDialog {
    private ActivityGuide activityGuide;
    private Milestone milestone;
    private MilestonePropertiesPanel milestonePanel;

    public NewMilestoneDialog(UiWindow uiParent, Msg msg, ActivityGuide activityGuide) {
        super(uiParent, msg);
        this.activityGuide = activityGuide;
        this.init();
    }

    public void ok() {
        try {
            this.milestone = this.milestonePanel.fillValues();
            this.activityGuide.addChild((ProjectObject)this.milestone);
            this.setVisible(false);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            Log.logSevere(e);
        }
        catch (ValidationException e) {
            this.milestonePanel.populateValues();
            MessageDialog.showError((Msg)e.getMsg());
        }
    }

    public Milestone getMilestone() {
        return this.milestone;
    }

    private void init() {
        this.milestonePanel = new MilestonePropertiesPanel(this.getContentPane(), this.activityGuide, null);
        this.getContentPane().add((UiComponent)this.milestonePanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

