/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.TranslationService;
import oracle.bpm.designer.activityguide.NewMilestoneAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.project.activityguide.ActivityRefImpl;
import oracle.bpm.project.activityguide.ResourceBundleImpl;
import oracle.bpm.project.activityguide.TranslatableValueImpl;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.ActivityRef;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.activityguide.ResourceBundle;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class MilestoneActivityPanel
extends Panel {
    private Activity activity;
    private ActivityGuide activityGuide;
    private CheckBox blockedIconCheckBox;
    private TextField blockedIconTextField;
    private Button browseUserTaskButton;
    private ComboBox<DisplayMode> displayModeComboBox;
    private CheckBox lastTaskCheckBox;
    private Button localizedButton;
    private MilestoneActivity milestoneActivity;
    private ComboBox<Milestone> milestonesCombobox;
    private ProjectListener<Milestone> milestonesProjectListener;
    private ResourceBundle resourceBundle;
    private CheckBox showTaskCheckBox;
    private NumericField<Integer> tasksRemainingTextField;
    private TranslatableValue translatableBlockedIconText;
    private TranslationService translationService;
    private ComboBox<TranslationType> translationTypeComboBox;
    private TextField userTaskTextField;

    public MilestoneActivityPanel(UiContainer parent, @NotNull ActivityGuide activityGuide, MilestoneActivity milestoneActivity, Activity activity) {
        super(parent);
        this.activity = activity;
        this.milestoneActivity = milestoneActivity;
        this.activityGuide = activityGuide;
        this.setLayout((Layout)new BorderLayout());
        this.buildUi();
        this.addMilestoneListener();
    }

    public ActivityRef getActivity() {
        return new ActivityRefImpl(this.activity);
    }

    public Milestone getMilestone() {
        return (Milestone)this.milestonesCombobox.getSelectedItem();
    }

    public boolean isShowTaskAsOptional() {
        return this.showTaskCheckBox.isSelected();
    }

    public boolean isDisplayBlockedIcon() {
        return this.blockedIconCheckBox.isSelected();
    }

    public int getTasksRemaining() {
        return (Integer)this.tasksRemainingTextField.getValue();
    }

    public DisplayMode getDisplayMode() {
        return (DisplayMode)this.displayModeComboBox.getSelectedItem();
    }

    public boolean isLasTaskInMilestone() {
        return this.lastTaskCheckBox.isSelected();
    }

    public void fillValues(MilestoneActivity milestone) {
        milestone.setMilestone(this.getMilestone());
        milestone.setMarkedAsOptional(this.isShowTaskAsOptional());
        milestone.setDisplayBlockedIcon(this.isDisplayBlockedIcon());
        if (this.translationTypeComboBox.getSelectedItem() == TranslationType.STATIC) {
            this.translatableBlockedIconText.setValue(this.blockedIconTextField.getText());
            this.translatableBlockedIconText.setType(TranslationType.STATIC);
        }
        milestone.setBlockedIconText(this.translatableBlockedIconText);
        milestone.setTasksRemaining(this.getTasksRemaining());
        milestone.setDisplayMode(this.getDisplayMode());
        milestone.setLastTaskInMilestone(this.isLasTaskInMilestone());
    }

    void removeListeners() {
        this.activityGuide.removeListener(this.milestonesProjectListener);
    }

    private void addMilestoneListener() {
        this.milestonesProjectListener = new ProjectListenerAdapter<Milestone>(Milestone.class){

            public Class getSupportedTypes() {
                return Milestone.class;
            }

            public void postObjectAdded(Milestone object, ProjectObject parent) {
                MilestoneActivityPanel.this.milestonesCombobox.addItem((Object)object);
            }
        };
        this.activityGuide.addListener(this.milestonesProjectListener);
    }

    private void buildUi() {
        Panel panel = Panel.createPanelWithBorder((UiContainer)this);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 5"));
        this.resourceBundle = this.activityGuide.getResourceBundle() == null ? new ResourceBundleImpl() : this.activityGuide.getResourceBundle();
        Panel userTaskPanel = this.buildUserTaskPanel((UiContainer)panel);
        Panel milestonePanel = this.buildMilestonePanel((UiContainer)panel);
        this.showTaskCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.SHOW_TASK_AS_OPTIONAL);
        this.blockedIconCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.DISPLAY_BLOCKED_ICON);
        this.blockedIconCheckBox.addItemListener(this.getBlockedIconCheckBoxItemListener());
        Panel translationPanel = this.buildTranslationPanel((UiContainer)panel);
        this.tasksRemainingTextField = NumericField.createIntegerNumericField((UiContainer)panel);
        this.displayModeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])DisplayMode.values());
        this.displayModeComboBox.setLabelProvider(this.getDisplayModeLabelProvider());
        this.lastTaskCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.LAST_TASK_IN_MILESTONE);
        this.populateValues();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.USER_TASK));
        panel.add((UiComponent)userTaskPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)ProjectMsg.MILESTONE));
        panel.add((UiComponent)milestonePanel, (Object)"growx, wrap");
        panel.add((UiComponent)this.showTaskCheckBox, (Object)"skip 1, wrap");
        panel.add((UiComponent)this.blockedIconCheckBox, (Object)"skip 1, wrap");
        panel.add((UiComponent)translationPanel, (Object)"skip 1, growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TASKS_REMAINING));
        panel.add(this.tasksRemainingTextField, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DISPLAY_MODE));
        panel.add(this.displayModeComboBox, (Object)"wrap");
        panel.add((UiComponent)this.lastTaskCheckBox, (Object)"skip 1, wrap");
        this.add((UiComponent)panel, "Center");
    }

    private Panel buildUserTaskPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.userTaskTextField = new TextField((UiContainer)panel);
        this.userTaskTextField.setEditable(false);
        this.browseUserTaskButton = Button.createBrowse((UiContainer)panel);
        this.browseUserTaskButton.addActionListener(this.getBrowseTaskAction());
        panel.add((UiComponent)this.userTaskTextField, (Object)"growx");
        panel.add((UiComponent)this.browseUserTaskButton, (Object)"wrap");
        return panel;
    }

    private Panel buildMilestonePanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.milestonesCombobox = UiFactory.createComboBox((UiContainer)panel, this.getAvailableMilestones());
        this.milestonesCombobox.setLabelProvider(this.getMilestoneLabelProvider());
        Button addMilestoneButton = Button.createIconic((UiContainer)panel, (Msg)DesignerMsg.ADD);
        addMilestoneButton.addActionListener(this.getAddMilestoneButtonActionListener());
        panel.add(this.milestonesCombobox, (Object)"growx");
        panel.add((UiComponent)addMilestoneButton, (Object)"wrap");
        return panel;
    }

    private Panel buildTranslationPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.translatableBlockedIconText = this.milestoneActivity != null ? this.milestoneActivity.getTranslatableBlockedIconText() : new TranslatableValueImpl(TranslationType.STATIC, "");
        this.translationTypeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TranslationType.values());
        this.translationTypeComboBox.setLabelProvider(this.getTranslationTypeLabelProvider());
        this.translationTypeComboBox.setSelectedItem((Object)this.translatableBlockedIconText.getType());
        this.translationTypeComboBox.addItemListener(this.getTranslationTypeComboBoxItemListener());
        this.blockedIconTextField = new TextField((UiContainer)panel);
        this.localizedButton = Button.createIconic((UiContainer)panel, (Msg)DesignerMsg.LOCALIZED_MESSAGE);
        this.localizedButton.setEnabled(this.translatableBlockedIconText.getType() == TranslationType.RESOURCE);
        this.localizedButton.addActionListener(this.getLocalizedButtonActionListener(this.translatableBlockedIconText, (TextComponent)this.blockedIconTextField));
        panel.add(this.translationTypeComboBox);
        panel.add((UiComponent)this.blockedIconTextField, (Object)"growx");
        panel.add((UiComponent)this.localizedButton, (Object)"wrap");
        return panel;
    }

    private ActionListener getAddMilestoneButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewMilestoneAction action = new NewMilestoneAction(MilestoneActivityPanel.this.activityGuide);
                action.run();
                if (action.getMilestone() != null) {
                    MilestoneActivityPanel.this.milestonesCombobox.setSelectedItem((Object)action.getMilestone());
                }
            }
        };
    }

    private ItemListener getTranslationTypeComboBoxItemListener() {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TranslationType translatableType = (TranslationType)e.getItem();
                MilestoneActivityPanel.this.localizedButton.setEnabled(translatableType == TranslationType.RESOURCE);
            }
        };
    }

    private ItemListener getBlockedIconCheckBoxItemListener() {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MilestoneActivityPanel.this.setEnableBlockedIconTextField(MilestoneActivityPanel.this.blockedIconCheckBox.isSelected());
            }
        };
    }

    private void setEnableBlockedIconTextField(boolean enable) {
        this.translationTypeComboBox.setEnabled(enable);
        this.blockedIconTextField.setEnabled(enable);
        this.localizedButton.setEnabled(enable && this.translationTypeComboBox.getSelectedItem() == TranslationType.RESOURCE);
    }

    private LabelProvider<DisplayMode> getDisplayModeLabelProvider() {
        return new LabelProvider<DisplayMode>(){

            public String getText(DisplayMode displayMode) {
                return displayMode.getLabel().toString();
            }

            public Image getIcon(DisplayMode element) {
                return null;
            }
        };
    }

    private LabelProvider<Milestone> getMilestoneLabelProvider() {
        return new LabelProvider.Default<Milestone>(){

            public String getText(Milestone milestone) {
                return ProjectObjectRenderer.Default.getLabel((ProjectObject)milestone);
            }
        };
    }

    private ActionListener getBrowseTaskAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final FolderContainer modelsRoot = MilestoneActivityPanel.this.activityGuide.getProject().getModelsRoot();
                ProjectFilter filter = new ProjectFilter(){

                    @NotNull
                    public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
                        if (object instanceof NodeContainer) {
                            Sequence taskSequence = ModelUtils.selectBpmnClass((Sequence)object.getChildrenByType(UserTask.class), UserTask.class);
                            ArrayList<UserTask> list = new ArrayList<UserTask>();
                            for (UserTask userTask : taskSequence) {
                                if (ModelUtils.isInAnyMilestone((UserTask)userTask)) continue;
                                list.add(userTask);
                            }
                            return CollectionUtils.asSequence(list);
                        }
                        return object.getChildren();
                    }

                    public ProjectObjectContainer getParent(ProjectObject object) {
                        return (ProjectObjectContainer)(object == modelsRoot ? null : object.getParentObject());
                    }
                };
                MilestoneActivityPanel.this.activity = (Activity)new ProjectNavigatorBuilder((ProjectObject)modelsRoot, DesignerMsg.BROWSE_USER_TASKS).showRoot().filter(filter).selectSingle(UserTask.class);
                if (MilestoneActivityPanel.this.activity != null) {
                    MilestoneActivityPanel.this.userTaskTextField.setText(MilestoneActivityPanel.this.activity.getDefaultLabel());
                }
            }
        };
    }

    private void populateValues() {
        if (this.milestoneActivity != null) {
            this.userTaskTextField.setText(this.milestoneActivity.getDefaultLabel());
            this.userTaskTextField.setEnabled(false);
            this.browseUserTaskButton.setEnabled(false);
            this.milestonesCombobox.setSelectedItem((Object)this.milestoneActivity.getMilestone());
            this.showTaskCheckBox.setSelected(this.milestoneActivity.isMarkedAsOptional());
            this.translationTypeComboBox.setSelectedItem((Object)this.milestoneActivity.getTranslatableBlockedIconText().getType());
            this.blockedIconCheckBox.setSelected(this.milestoneActivity.isDisplayBlockedIcon());
            this.blockedIconTextField.setText(this.getTranslatedValue(this.milestoneActivity.getTranslatableBlockedIconText()));
            this.tasksRemainingTextField.setValue((Number)this.milestoneActivity.getTasksRemaining());
            this.displayModeComboBox.setSelectedItem((Object)this.milestoneActivity.getDisplayMode());
            this.lastTaskCheckBox.setSelected(this.milestoneActivity.isLastTaskInMilestone());
        } else if (this.activity != null) {
            this.userTaskTextField.setText(this.activity.getDefaultLabel());
        }
        this.setEnableBlockedIconTextField(this.blockedIconCheckBox.isSelected());
    }

    private String getTranslatedValue(TranslatableValue translatableValue) {
        if (translatableValue.getType() == TranslationType.RESOURCE && this.getTranslationService() != null) {
            return this.getTranslationService().translate(translatableValue.getValue());
        }
        return translatableValue.getValue();
    }

    private Collection<Milestone> getAvailableMilestones() {
        return SequenceBuilder.create(this.activityGuide.getChildrenByType(Milestone.class)).toCollection();
    }

    private LabelProvider<TranslationType> getTranslationTypeLabelProvider() {
        return new LabelProvider.Default<TranslationType>(){

            public String getText(TranslationType element) {
                return element.getMsg().toString();
            }
        };
    }

    private ActionListener getLocalizedButtonActionListener(final TranslatableValue translatableValue, final TextComponent textComponent) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedKey;
                String currentKey;
                String string = currentKey = translatableValue.getType() == TranslationType.RESOURCE ? translatableValue.getValue() : null;
                if (MilestoneActivityPanel.this.getTranslationService() != null && (selectedKey = MilestoneActivityPanel.this.getTranslationService().browseResourceBundle((UiContainer)MilestoneActivityPanel.this, currentKey)) != null) {
                    translatableValue.setValue(selectedKey);
                    translatableValue.setType(TranslationType.RESOURCE);
                    textComponent.setText(MilestoneActivityPanel.this.getTranslationService().translate(selectedKey));
                    MilestoneActivityPanel.this.resourceBundle.setName(MilestoneActivityPanel.this.getTranslationService().getResourceBundleName());
                    MilestoneActivityPanel.this.resourceBundle.setLocation("");
                }
            }
        };
    }

    private TranslationService getTranslationService() {
        if (this.translationService == null) {
            this.translationService = AbstractStudioWorkbench.getInstance().getTranslationService((UiContainer)this, this.activityGuide.getProject(), this.resourceBundle.getName());
        }
        return this.translationService;
    }
}

