/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.activityguide.MilestoneActivityPanel;
import oracle.bpm.log.Log;
import oracle.bpm.project.command.activityguide.AddFlowNodeToMilestoneCommand;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.ActivityRef;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.VisibilityListener;

public class AddMilestoneActivityToMilestoneDialog
extends OkCancelDialog {
    private Activity activity;
    private ActivityGuide activityGuide;
    private MilestoneActivityPanel milestoneActivityPanel;

    public AddMilestoneActivityToMilestoneDialog(UiWindow parent, Msg title, ActivityGuide activityGuide, Activity activity) {
        super(parent, title);
        this.activityGuide = activityGuide;
        this.activity = activity;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ok() {
        ActivityRef activityRef = this.milestoneActivityPanel.getActivity();
        Milestone milestone = this.milestoneActivityPanel.getMilestone();
        try {
            MilestoneActivity milestoneActivity = milestone.createMilestoneActivity(activityRef);
            this.milestoneActivityPanel.fillValues(milestoneActivity);
            ActionRunner.getInstance().run((Command)new AddFlowNodeToMilestoneCommand(milestoneActivity, milestone));
        }
        catch (ProjectException e) {
            Log.logSevere(e);
        }
        finally {
            this.setVisible(false);
        }
    }

    private void init() {
        this.milestoneActivityPanel = new MilestoneActivityPanel(this.getContentPane(), this.activityGuide, null, this.activity);
        this.getContentPane().add((UiComponent)this.milestoneActivityPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.addVisibilityListener(new VisibilityListener(){

            public void onDispose() {
                AddMilestoneActivityToMilestoneDialog.this.milestoneActivityPanel.removeListeners();
            }
        });
    }
}

