/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.TranslationService;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.project.activityguide.ResourceBundleImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.ResourceBundle;
import oracle.bpm.project.model.activityguide.TaskAccessMode;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.FileFilter;

public class ActivityGuidePropertiesPanel
extends Panel {
    private ActivityGuide activityGuide;
    private TextArea descriptionField;
    private ComboBox<TranslationType> descriptionTypeComboBox;
    private ComboBox<DisplayMode> displayModeComboBox;
    private TextField iconLocationTextField;
    private ResourceBundle resourceBundle;
    private TextField reSrcBundleLocationTextField;
    private ComboBox<Process> rootProcessComboBox;
    private ComboBox<TaskAccessMode> taskAccessModeComboBox;
    private TextField titleTextField;
    private ComboBox<TranslationType> titleTypeComboBox;
    private TranslatableValue translatableDescription;
    private TranslatableValue translatableTitle;
    private TranslationService translationService;

    public ActivityGuidePropertiesPanel(UiContainer parent, ActivityGuide activityGuide) {
        super(parent);
        this.activityGuide = activityGuide;
        this.setLayout((Layout)new BorderLayout());
        this.buildUi();
    }

    public String getTitle() {
        return this.titleTextField.getText();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public String getIconLocation() {
        return this.iconLocationTextField.getText();
    }

    public Process getRootProcess() {
        return (Process)this.rootProcessComboBox.getSelectedItem();
    }

    public DisplayMode getDisplayMode() {
        return (DisplayMode)this.displayModeComboBox.getSelectedItem();
    }

    public TaskAccessMode getTaskAccessMode() {
        return (TaskAccessMode)this.taskAccessModeComboBox.getSelectedItem();
    }

    public void fillValues(ActivityGuide activityGuide) {
        Process rootProcess;
        if (this.titleTypeComboBox.getSelectedItem() == TranslationType.STATIC) {
            this.translatableTitle.setValue(this.getTitle());
            this.translatableTitle.setType(TranslationType.STATIC);
        }
        activityGuide.setTitle(this.translatableTitle);
        if (this.descriptionTypeComboBox.getSelectedItem() == TranslationType.STATIC) {
            this.translatableDescription.setValue(this.getDescription());
            this.translatableDescription.setType(TranslationType.STATIC);
        }
        activityGuide.setDescription(this.translatableDescription);
        activityGuide.setIconLocation(this.getIconLocation());
        if (!Str.isEmpty(this.resourceBundle.getName())) {
            activityGuide.setResourceBundle(this.resourceBundle);
        }
        if ((rootProcess = this.getRootProcess()) != null) {
            activityGuide.setRootProcess(rootProcess);
        }
        activityGuide.setDisplayMode(this.getDisplayMode());
        activityGuide.setTaskAccessMode(this.getTaskAccessMode());
    }

    private void buildUi() {
        Panel panel = Panel.createPanelWithBorder((UiContainer)this);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 5"));
        this.translatableTitle = this.activityGuide.getTranslatableTitle();
        Panel titlePanel = this.buildTitlePanel((UiContainer)panel);
        Panel descriptionPanel = this.buildDescriptionPanel((UiContainer)panel);
        Panel iconPanel = this.buildIconPanel((UiContainer)panel);
        this.reSrcBundleLocationTextField = new TextField((UiContainer)panel);
        this.reSrcBundleLocationTextField.setEnabled(false);
        this.rootProcessComboBox = UiFactory.createComboBox((UiContainer)panel, new ArrayList(this.activityGuide.getProject().getProcesses()));
        this.rootProcessComboBox.setSelectedItem((Object)this.activityGuide.getRootProcess());
        this.rootProcessComboBox.setLabelProvider(this.getProcessLabelProvider());
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        arrayList.add(DisplayMode.ALWAYS);
        arrayList.add(DisplayMode.WHEN_INSTANTIATED);
        this.displayModeComboBox = UiFactory.createComboBox((UiContainer)panel, arrayList);
        this.displayModeComboBox.setSelectedItem((Object)this.activityGuide.getDisplayMode());
        this.displayModeComboBox.setLabelProvider(this.getDisplayModeLabelProvider());
        this.taskAccessModeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TaskAccessMode.values());
        this.taskAccessModeComboBox.setSelectedItem((Object)this.activityGuide.getTaskAccessMode());
        this.taskAccessModeComboBox.setLabelProvider(this.getTaskAccessModeLabelProvider());
        this.populateValues();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TITLE));
        panel.add((UiComponent)titlePanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DESCRIPTION));
        panel.add((UiComponent)descriptionPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.ICON_LOCATION));
        panel.add((UiComponent)iconPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.RESOURCE_BUNDLE_LOCATION));
        panel.add((UiComponent)this.reSrcBundleLocationTextField, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.ROOT_PROCESS));
        panel.add(this.rootProcessComboBox, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DISPLAY_MODE));
        panel.add(this.displayModeComboBox, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TASK_ACCESS_MODE));
        panel.add(this.taskAccessModeComboBox, (Object)"wrap");
        this.add((UiComponent)panel, "Center");
    }

    private Panel buildTitlePanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.titleTextField = new TextField((UiContainer)panel);
        this.titleTypeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TranslationType.values());
        this.titleTypeComboBox.setLabelProvider(this.getTranslationTypeLabelProvider());
        this.titleTypeComboBox.setSelectedItem((Object)this.translatableTitle.getType());
        this.resourceBundle = this.activityGuide.getResourceBundle() == null ? new ResourceBundleImpl() : this.activityGuide.getResourceBundle();
        Button titleLocalizedButton = new Button((UiContainer)panel, Image.create((Msg)DesignerMsg.LOCALIZED_MESSAGE));
        Button.fixSize((Button)titleLocalizedButton);
        titleLocalizedButton.setEnabled(this.translatableTitle.getType() == TranslationType.RESOURCE);
        titleLocalizedButton.addActionListener(this.getLocalizedButtonActionListener(this.translatableTitle, (TextComponent)this.titleTextField));
        this.titleTypeComboBox.addItemListener(this.getTranslationTypeItemListener(titleLocalizedButton));
        panel.add(this.titleTypeComboBox);
        panel.add((UiComponent)this.titleTextField, (Object)"growx");
        panel.add((UiComponent)titleLocalizedButton, (Object)"wrap");
        return panel;
    }

    private Panel buildDescriptionPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.translatableDescription = this.activityGuide.getTranslatableDescription();
        this.descriptionTypeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TranslationType.values());
        this.descriptionTypeComboBox.setSelectedItem((Object)this.translatableDescription.getType());
        this.descriptionTypeComboBox.setLabelProvider(this.getTranslationTypeLabelProvider());
        this.descriptionField = new TextArea((UiContainer)panel);
        this.descriptionField.setColumns(30);
        this.descriptionField.setRows(4);
        Button descriptionLocalizedButton = new Button((UiContainer)panel, Image.create((Msg)DesignerMsg.LOCALIZED_MESSAGE));
        Button.fixSize((Button)descriptionLocalizedButton);
        descriptionLocalizedButton.setEnabled(this.translatableDescription.getType() == TranslationType.RESOURCE);
        descriptionLocalizedButton.addActionListener(this.getLocalizedButtonActionListener(this.translatableDescription, (TextComponent)this.descriptionField));
        this.descriptionTypeComboBox.addItemListener(this.getTranslationTypeItemListener(descriptionLocalizedButton));
        panel.add(this.descriptionTypeComboBox);
        panel.add((UiComponent)this.descriptionField, (Object)"growx");
        panel.add((UiComponent)descriptionLocalizedButton, (Object)"aligny top, wrap");
        return panel;
    }

    private Panel buildIconPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.iconLocationTextField = new TextField((UiContainer)panel, 30);
        Button browseIconButton = Button.createBrowse((UiContainer)panel);
        browseIconButton.addActionListener(this.getIconLocationActionListener());
        panel.add((UiComponent)this.iconLocationTextField, (Object)"growx");
        panel.add((UiComponent)browseIconButton, (Object)"wrap");
        return panel;
    }

    private LabelProvider<TaskAccessMode> getTaskAccessModeLabelProvider() {
        return new LabelProvider<TaskAccessMode>(){

            public Image getIcon(TaskAccessMode element) {
                return null;
            }

            public String getText(TaskAccessMode element) {
                return element.getLabel().toString();
            }
        };
    }

    private LabelProvider<DisplayMode> getDisplayModeLabelProvider() {
        return new LabelProvider<DisplayMode>(){

            public Image getIcon(DisplayMode element) {
                return null;
            }

            public String getText(DisplayMode element) {
                return element.getLabel().toString();
            }
        };
    }

    private LabelProvider<Process> getProcessLabelProvider() {
        return new LabelProvider<Process>(){

            public Image getIcon(Process element) {
                return null;
            }

            public String getText(Process element) {
                return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
            }
        };
    }

    private ActionListener getLocalizedButtonActionListener(final TranslatableValue translatableValue, final TextComponent textComponent) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedKey;
                String currentKey;
                String string = currentKey = translatableValue.getType() == TranslationType.RESOURCE ? translatableValue.getValue() : null;
                if (ActivityGuidePropertiesPanel.this.getTranslationService() != null && (selectedKey = ActivityGuidePropertiesPanel.this.getTranslationService().browseResourceBundle((UiContainer)ActivityGuidePropertiesPanel.this, currentKey)) != null) {
                    translatableValue.setValue(selectedKey);
                    translatableValue.setType(TranslationType.RESOURCE);
                    textComponent.setText(ActivityGuidePropertiesPanel.this.getTranslationService().translate(selectedKey));
                    ActivityGuidePropertiesPanel.this.resourceBundle.setName(ActivityGuidePropertiesPanel.this.getTranslationService().getResourceBundleName());
                    ActivityGuidePropertiesPanel.this.resourceBundle.setLocation("");
                    ActivityGuidePropertiesPanel.this.reSrcBundleLocationTextField.setText(ActivityGuidePropertiesPanel.this.resourceBundle.getName());
                }
            }
        };
    }

    private void populateValues() {
        this.titleTextField.setText(this.getTranslatedValue(this.activityGuide.getTranslatableTitle()));
        this.descriptionField.setText(this.getTranslatedValue(this.activityGuide.getTranslatableDescription()));
        this.iconLocationTextField.setText(this.activityGuide.getIconLocation());
        ResourceBundle resourceBundle = this.activityGuide.getResourceBundle();
        if (resourceBundle != null) {
            this.reSrcBundleLocationTextField.setText(resourceBundle.getName());
        }
        if (this.activityGuide.getRootProcess() != null) {
            this.rootProcessComboBox.setSelectedItem((Object)this.activityGuide.getRootProcess());
        }
    }

    private String getTranslatedValue(TranslatableValue translatableValue) {
        if (translatableValue.getType() == TranslationType.RESOURCE && this.getTranslationService() != null) {
            return this.getTranslationService().translate(translatableValue.getValue());
        }
        return translatableValue.getValue();
    }

    private TranslationService getTranslationService() {
        if (this.translationService == null) {
            this.translationService = AbstractStudioWorkbench.getInstance().getTranslationService((UiContainer)this, this.activityGuide.getProject(), this.resourceBundle.getName());
        }
        return this.translationService;
    }

    private ItemListener getTranslationTypeItemListener(final Button localizedButton) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TranslationType translationType = (TranslationType)e.getItem();
                localizedButton.setEnabled(translationType == TranslationType.RESOURCE);
            }
        };
    }

    private LabelProvider<TranslationType> getTranslationTypeLabelProvider() {
        return new LabelProvider<TranslationType>(){

            public Image getIcon(TranslationType element) {
                return null;
            }

            public String getText(TranslationType element) {
                return element.getMsg().toString();
            }
        };
    }

    private ActionListener getIconLocationActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void actionPerformed(ActionEvent e) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setFileFilter(FileFilter.create(DesignerMsg.GIF_IMAGE, ".gif", ".jpg", ".jpeg", ".jpe"));
                fileChooser.showOpenDialog((UiComponent)ActivityGuidePropertiesPanel.this, DesignerMsg.BROWSE_ICONS);
                VFileSystem dataFileSystem = ActivityGuidePropertiesPanel.this.activityGuide.getProject().getLoader().getProjectFileSystem().getDataFileSystem();
                VFile resourcesDirectory = dataFileSystem.createFile(Path.RESOURCES.getName());
                File imageFile = fileChooser.getSelectedFile();
                if (imageFile != null) {
                    FileInputStream imageFileIS = null;
                    try {
                        VFile destinationVFile = dataFileSystem.createFile(resourcesDirectory, imageFile.getName());
                        if (!destinationVFile.exists()) {
                            imageFileIS = new FileInputStream(imageFile);
                            VFileUtils.fileCopy((InputStream)imageFileIS, (VFile)destinationVFile);
                        }
                        ActivityGuidePropertiesPanel.this.iconLocationTextField.setText(destinationVFile.toString().replaceFirst("/", ""));
                    }
                    catch (FileNotFoundException e1) {
                        Log.logSevere(e1);
                        StreamUtils.close(imageFileIS);
                    }
                    catch (IOException e12) {
                        Log.logSevere(e12);
                        {
                            catch (Throwable throwable) {
                                StreamUtils.close(imageFileIS);
                                throw throwable;
                            }
                        }
                        StreamUtils.close(imageFileIS);
                    }
                    StreamUtils.close(imageFileIS);
                }
            }
        };
    }
}

